;{Note1,Note,12,"MOVES Scripts for 2015 ABM - Automated process"}
;{year,editbox,"Year (Two-digit)",N,"40"}
;{year4d,editbox,"Year (Four-digit)",N,"2040"}
;{Inpzones,editbox,"Enter Total  Number of  Zones:   ",N,"5981"}
;{ext1,editbox,"First External Station",T,"5874"}
;{ext2,editbox,"Last External Station",T,"5981"}
;{county13,editbox,"13 county zone list",T,"1-4771"}
;{county7,editbox,"7 county zone list",T,"4772-5873"}
;{county5,editbox,"5 county zone list",T,"1-3006,3387-3624"}
;{county2,editbox,"2 county zone list",T,"4772-4942,5264-5407"}

;Make necessary directories for model to run (no longer appears to work) 
;RUN CreateFolders.BAT
;*mkdir 13Co_O3\MOVESInputs
;*mkdir 13Co_PM\MOVESInputs
;*mkdir 7Co_O3\MOVESInputs
;*mkdir 7Co_PM\MOVESInputs
;*mkdir 5Co_O3\MOVESInputs
;*mkdir 5Co_PM\MOVESInputs

 ;=======================================================================================
 ;INPUT FILES (some are located below in the pollutant loop (search Pollutant Loop)
 HDSOURCE = 'inputs\MOVES_Defaults_HdSrcFractionsbyYear.csv'
 SOURCE13 = 'Inputs\MOVES_Defaults_13SrcVehbyYear.csv'
; HPMSBYYEAR = 'inputs\MOVES_Defaults_5HPMSbyYear.csv'  ; no longer needed to split vtype 20 and 30
 MONTHLYWEEKEND = 'Inputs\MOVES_Defaults_MonthlyWeekendAdjFactors.csv'
 HPMS_CORR = 'Inputs\hpms_corr_ABM.dat'
 RoadType  = 'Inputs\road_type.dat'
 HOURVMT =  'Inputs\MOVES_Defaults_HourVMTFraction.csv'
 HourFracRT1 = 'INPUTS\MOVES_Defaults_HourFractions_RdType1.CSV'
 SpeedBin = 'Inputs\speed_bin.dat'
 
;HDSOURCE = MOVES defaults for VMT per HD source 62
;SOURCE13 = MOVES defaults for 13 source vehicles
;HPMSBYYEAR = MOVES defaults for 5 HPMS types by year
;MONTHLYWEEKEND = MOVES defaults monthly / weekend adjustment factors
;HPMS_CORR = HPMS corrections for missing FCLASS
 ;=======================================================================================
; Process transit model outputs to determine bus link volumes by hour
;========================================================================================
; loop through 5 transit time periods (not within pollutant loop because of run time
LOOP N=1,5
IF(N=1)
 PER='EA'
 HDWY=1
ELSEIF(N=2)
 PER='AM'
 HDWY=2
ELSEIF(N=3)
 PER='MD'
 HDWY=3
ELSEIF(N=4)
 PER='PM'
 HDWY=4
ELSEIF(N=5)
 PER='EV'
 HDWY=5
ENDIF

RUN PGM=MATRIX
  DBI[1]=..\ModelData\wlk_alltrn_wlk_@PER@.dbf,SORT=A,B
  RECO[1]="@PER@_TRN.DBF",FIELDS=A,B,TIME1,DISTANCE,SPEED,TRN_HR

  ZONES=1

  LOOP K=1,DBI.1.NUMRECORDS
    PRINT FORM=10.0,LIST='Processing Record # ',K,PRINTO=0
    ; Get the needed variables for this record
    X=DBIReadRecord(1,K)
    A=DI.1.A
    B=DI.1.B
    FREQ=DI.1.HEADWAY_@HDWY@
    TIME1=DI.1.TIME
    IF (TIME1=0) TIME1=0.01
    DISTANCE=DI.1.DIST
    IF (DISTANCE=0) DISTANCE=0.001
    SPEED=DISTANCE/TIME1*60
    TRN_HR1=0
    IF (FREQ>0) TRN_HR1=60/FREQ
    ; Use mode to remove rail links
    DELFLAG=0
    MODEC=SUBSTR(STR(DI.1.MODE,2,0),2,1) ; RIGHT-MOST CHARACTER IN THE MODE
    IF ( MODEC='1' | MODEC='2' | MODEC='3' | MODEC='5') DELFLAG=1
 ;   IF (MODEC='3' | MODEC='5') DELFLAG=1
    ; Determine this record's relationship to previous and next records
    NEWFLAG=0
    LASTFLAG=0
    IF (K=1)
      NEWFLAG=1
    ELSEIF (K=DBI.1.NUMRECORDS)
      LASTFLAG=1
    ELSE
      X=DBIReadRecord(1,K-1)
      LASTA=DI.1.A
      LASTB=DI.1.B
      IF (A<>LASTA | B<>LASTB) NEWFLAG=1
      X=DBIReadRecord(1,K+1)
      NEXTA=DI.1.A
      NEXTB=DI.1.B
      IF (A<>NEXTA | B<>NEXTB) LASTFLAG=1
    ENDIF

    IF (NEWFLAG=1)
      TRN_HR=TRN_HR1
      IF (LASTFLAG=1 & TRN_HR>0 & DELFLAG=0) WRITE RECO=1
    ELSE
      TRN_HR=TRN_HR+TRN_HR1
      IF (LASTFLAG=1 & TRN_HR>0 & DELFLAG=0) WRITE RECO=1
    ENDIF
  ENDLOOP
ENDRUN
ENDLOOP

;Pollutant Loop
;loop through 4 pollutants (loops are specific for each pollutant)
; - loop 1 is 13 county ozone
; - loop 2 is 13 county PM
; - loop 3 is 7 county ozone
; - loop 4 is 7 county PM
; - loop 5 is 5 county ozone
; - loop 6 is 5 county PM

LOOP POL=1,8
 IF(POL=1)
  POLLUTANT = '13Co_O3'
  HPMSADJ = 'Inputs\HPMS_13Co_OZ_ABM_031315.DAT'
  GDOTHPMS = 'inputs\HPMS5_ByRdType_13Co_CombinedUrbRural.csv'
 ELSEIF(POL=2)
  POLLUTANT ='13Co_PM'
  HPMSADJ = 'Inputs\HPMS_13Co_PM25_ABM_031315.DAT'
  GDOTHPMS = 'inputs\HPMS5_ByRdType_13Co_CombinedUrbRural.csv'
 ELSEIF(POL=3)
  POLLUTANT ='7Co_O3'
  HPMSADJ = 'Inputs\HPMS_7Co_OZ_ABM_031315.DAT'
  GDOTHPMS = 'inputs\HPMS5_ByRdType_7Co_CombinedUrbRural.csv'
 ELSEIF(POL=4)
  POLLUTANT ='7Co_PM'
  HPMSADJ = 'Inputs\HPMS_7Co_PM25_ABM_031315.DAT'
  GDOTHPMS = 'inputs\HPMS5_ByRdType_7Co_CombinedUrbRural.csv'
 ELSEIF(POL=5)
  POLLUTANT = '5Co_O3'
  HPMSADJ = 'Inputs\HPMS_13Co_OZ_ABM_031315.DAT'
  GDOTHPMS = 'inputs\HPMS5_ByRdType_13Co_CombinedUrbRural.csv'
 ELSEIF(POL=6)
  POLLUTANT ='5Co_PM'
  HPMSADJ = 'Inputs\HPMS_13Co_PM25_ABM_031315.DAT'
  GDOTHPMS = 'inputs\HPMS5_ByRdType_13Co_CombinedUrbRural.csv'
 ELSEIF(POL=7)
  POLLUTANT = '2Co_O3'
  HPMSADJ = 'Inputs\HPMS_7Co_OZ_ABM_031315.DAT'
  GDOTHPMS = 'inputs\HPMS5_ByRdType_7Co_CombinedUrbRural.csv'
 ELSEIF(POL=8)
  POLLUTANT ='2Co_PM'
  HPMSADJ = 'Inputs\HPMS_7Co_PM25_ABM_031315.DAT'
  GDOTHPMS = 'inputs\HPMS5_ByRdType_7Co_CombinedUrbRural.csv'
 ENDIF

;  This script creates the file MOVES_HRVOL.net which is used in the other 
;       postprocessing scripts - This file includes the following
;       Bus link volumes by hour
;        Assign MOVES road type to each link
;       Add transit volumes to the total volume
;       Split total modeled volume into hours

;  This script creates the AverageSpeedDistribution.dbf file for input to MOVES
;===========================================================================================
; Process HourVMTFraction.csv to create hourly lookup shares
;===========================================================================================
RUN PGM=MATRIX
  RECI=@hourvmt@,DELIMITER=',',     ; MOVE defaults
    sourceTypeID=1,roadTypeID=2,dayID=3,hourID=4,hourVMTFraction=5
  RECO[1]="@POLLUTANT@\HrShare.dbf",FIELDS=hour,PctRT1(10.5),PctRT2(10.5),PctRT3(10.5),PctRT4(10.5),PctRT5(10.5)
  RECO[2]="@POLLUTANT@\HrPct_Period.dbf",FIELDS=hour,PctRT1(10.5),PctRT2(10.5),PctRT3(10.5),PctRT4(10.5),PctRT5(10.5)

  zones=1

   ;Get MOVES default Source Vehicle fractions by year
        _year=int({year4d})

   Lookup Name=_moves11,             
    Lookup[1]=1,Result=2,File=@source13@,
     Interpolate=n
     _Frac11=_moves11(1,_year)
   Lookup Name=_moves21,             
    Lookup[1]=1,Result=3,File=@source13@,
     Interpolate=n
     _Frac21=_moves21(1,_year)
   Lookup Name=_moves31,             
    Lookup[1]=1,Result=4,File=@source13@,
     Interpolate=n
     _Frac31=_moves31(1,_year)
   Lookup Name=_moves32,             
    Lookup[1]=1,Result=5,File=@source13@,
     Interpolate=n
     _Frac32=_moves32(1,_year)
   Lookup Name=_moves41,             
    Lookup[1]=1,Result=6,File=@source13@,
     Interpolate=n
     _Frac41=_moves41(1,_year)
   Lookup Name=_moves42,             
    Lookup[1]=1,Result=7,File=@source13@,
     Interpolate=n
     _Frac42=_moves42(1,_year)
   Lookup Name=_moves43,             
    Lookup[1]=1,Result=8,File=@source13@,
     Interpolate=n
     _Frac43=_moves43(1,_year)
   Lookup Name=_moves51,             
    Lookup[1]=1,Result=9,File=@source13@,
     Interpolate=n
     _Frac51=_moves51(1,_year)
   Lookup Name=_moves52,             
    Lookup[1]=1,Result=10,File=@source13@,
     Interpolate=n
     _Frac52=_moves52(1,_year)
   Lookup Name=_moves53,             
    Lookup[1]=1,Result=11,File=@source13@,
     Interpolate=n
     _Frac53=_moves53(1,_year)
   Lookup Name=_moves54,             
    Lookup[1]=1,Result=12,File=@source13@,
     Interpolate=n
     _Frac54=_moves54(1,_year)
   Lookup Name=_moves61,             
    Lookup[1]=1,Result=13,File=@source13@,
     Interpolate=n
     _Frac61=_moves61(1,_year)
   Lookup Name=_moves62,             
    Lookup[1]=1,Result=14,File=@source13@,
     Interpolate=n
     _Frac62=_moves62(1,_year)

;      print list=_frac11(8.5),_frac21(8.5),_frac31(8.5)


  ; Array to store the input VMT Fractions
  ARRAY HRFRACT=13,5,24  ; sourceTypeID, roadTypeID, Hours

  ; Array to store the VMT Fractions by roadType (weighted by sourceType)
  ARRAY HRSHARE=24,5   ; Hour, roadTypeID

  ; Array to store the output hourly percents (normalized within each period)
  ARRAY HRPCT=24,5  ; Hour, roadTypeID

  ; set array indicies
  if (ri.sourceTypeID=11) N=1
  if (ri.sourceTypeID=21) N=2
  if (ri.sourceTypeID=31) N=3
  if (ri.sourceTypeID=32) N=4
  if (ri.sourceTypeID=41) N=5
  if (ri.sourceTypeID=42) N=6
  if (ri.sourceTypeID=43) N=7
  if (ri.sourceTypeID=51) N=8
  if (ri.sourceTypeID=52) N=9
  if (ri.sourceTypeID=53) N=10
  if (ri.sourceTypeID=54) N=11
  if (ri.sourceTypeID=61) N=12
  if (ri.sourceTypeID=62) N=13

  if (ri.dayID=5)
    HRFRACT[N][ri.roadTypeID][ri.hourID]=ri.hourVMTFraction
  endif

  ; Calculate the roadType hourly shares weighted by sourceType by year
  if (RECI.RECNO=RECI.NUMRECORDS)
    LOOP hour=1,24
      LOOP road=1,5
        LOOP source=1,13
          IF(source=1) FRACT = _frac11            ;0.0047
          IF(source=2) FRACT = _frac21            ;0.5922
          IF(source=3) FRACT = _frac31            ;0.2381
          IF(source=4) FRACT = _frac32            ;0.0795
          IF(source=5) FRACT = _frac41            ;0.0012
          IF(source=6) FRACT = _frac42            ;0.0003
          IF(source=7) FRACT = _frac43            ;0.0013
          IF(source=8) FRACT = _frac51            ;0.0003        
          IF(source=9) FRACT = _frac52            ;0.0298
          IF(source=10) FRACT = _frac53           ;0.0043
          IF(source=11) FRACT = _frac54           ;0.0017
          IF(source=12) FRACT = _frac61           ;0.0188
          IF(source=13) FRACT = _frac62           ;0.0277
          HRSHARE[hour][road]=HRSHARE[hour][road]+HRFRACT[source][road][hour]*FRACT
        ENDLOOP ;source
      ENDLOOP ;road
      ro.hour=hour
      ro.PctRT1=HRSHARE[hour][1]
      ro.PctRT2=HRSHARE[hour][2]
      ro.PctRT3=HRSHARE[hour][3]
      ro.PctRT4=HRSHARE[hour][4]
      ro.PctRT5=HRSHARE[hour][5]
      WRITE RECO=1
    ENDLOOP ;hour
  endif

  ; Calculate each hour's share of its associated period
  if (RECI.RECNO=RECI.NUMRECORDS)
    LOOP hour=1,24
      LOOP road=1,5
        easum=HRSHARE[4][road]+HRSHARE[5][road]+
              HRSHARE[6][road]
        amsum=HRSHARE[7][road]+HRSHARE[8][road]+
              HRSHARE[9][road]+HRSHARE[10][road]
        mdsum=HRSHARE[11][road]+HRSHARE[12][road]+
              HRSHARE[13][road]+HRSHARE[14][road]+
              HRSHARE[15][road]
        pmsum=HRSHARE[16][road]+HRSHARE[17][road]+
              HRSHARE[18][road]+HRSHARE[19][road]
        evsum=HRSHARE[1][road]+HRSHARE[2][road]+
              HRSHARE[3][road]+HRSHARE[20][road]+
              HRSHARE[21][road]+HRSHARE[22][road]+
              HRSHARE[23][road]+HRSHARE[24][road]
        if (hour=4-6)   period=1            ; early am
        if (hour=7-10)  period=2            ; am peak
        if (hour=11-15) period=3            ; midday
        if (hour=16-19) period=4            ; pm peak
        if (hour=1-3 | hour=20-24) period=5 ; evening
        if (period=1) HRPCT[hour][road]=HRSHARE[hour][road]/easum
        if (period=2) HRPCT[hour][road]=HRSHARE[hour][road]/amsum
        if (period=3) HRPCT[hour][road]=HRSHARE[hour][road]/mdsum
        if (period=4) HRPCT[hour][road]=HRSHARE[hour][road]/pmsum
        if (period=5) HRPCT[hour][road]=HRSHARE[hour][road]/evsum
      ENDLOOP ;road
      ro.hour=hour
      ro.PctRT1=HRPCT[hour][1]
      ro.PctRT2=HRPCT[hour][2]
      ro.PctRT3=HRPCT[hour][3]
      ro.PctRT4=HRPCT[hour][4]
      ro.PctRT5=HRPCT[hour][5]
      WRITE RECO=2
    ENDLOOP ;hour
  endif
ENDRUN


;===========================================================================================
; Assign MOVES road type to each link
; Add transit volumes to the total volume
; Split total modeled volume into hours
;===========================================================================================
RUN PGM=NETWORK
  NETI=..\ModelData\total{year}.net
  LINKI[2]="EA_TRN.DBF"
  LINKI[3]="AM_TRN.DBF"
  LINKI[4]="MD_TRN.DBF"
  LINKI[5]="PM_TRN.DBF"
  LINKI[6]="EV_TRN.DBF"
  LOOKUPI[1]="@Pollutant@\HrPct_Period.dbf"
  NETO="@Pollutant@\MOVES_HrVol.NET"

  ;FCLASS coded as interstate but FACTYPE not interstate
   IF(FCLASS=1,11 & FACTYPE>4)
    FCLASS=0
   ENDIF

  
  ;-----------------------------------------------------------
  ;     Correct links that do not have correct hpms code - Updated
  ;-----------------------------------------------------------
    Lookup Name=_setfclass,
      LOOKUP[1] =1, RESULT=2,             ;freeway
      LOOKUP[2] =1, RESULT=3,             ;expressway
      LOOKUP[3] =1, RESULT=4,             ;Parkway
      LOOKUP[4] =1, RESULT=5,             ;Freeway HOV buffer separated
      LOOKUP[5] =1, RESULT=6,             ;Freeway HOV Barrier separated
      LOOKUP[6] =1, RESULT=7,             ;Freeway Truck Only
      LOOKUP[7] =1, RESULT=8,             ;System to system ramp
      LOOKUP[8] =1, RESULT=9,             ;Exit ramp
      LOOKUP[9] =1, RESULT=10,            ;Entrance ramp
      LOOKUP[10]=1, RESULT=11,            ;Principal Arterial
      LOOKUP[11]=1, RESULT=12,            ;Minor Arterial
      LOOKUP[12]=1, RESULT=13,            ;Arterial HOV
      LOOKUP[13]=1, RESULT=14,            ;Arterial truck only
      LOOKUP[14]=1, RESULT=15,            ;Collector
      LOOKUP[20]=1, RESULT=16,            ;Centroid
          Interpolate=n,File=@hpms_corr@
  
  _areatype=li.1.atype
  _factype=li.1.factype
  if (_factype=0) _factype=20  ; shift centroid connectors from zero to 20
  ; if fclass is not one of the expected values or missing
  ; set the fclass using Facility Type and Area Type
  if (FCLASS=1,2,6,7,8,9,11,12,14,16,17,19) ; expected fclasses
    FCLASS=LI.1.FCLASS
  else  ; fclass missing
    FCLASS=_setfclass(_factype,_areatype)
  endif

  ; assume links only in the transit files are local roads
  if (li.1.a=0 & (li.2.a<>0 | li.3.a<>0 | li.4.a<>0 | li.5.a<>0 | li.6.a<>0))
    FCLASS=19
    if (_areatype=7) FCLASS=9
    FACTYPE=50

    ; use the transit only link distances, times & speeds
    TIME1=LI.2.TIME1
    DISTANCE=LI.2.DISTANCE
    SPEED=LI.2.SPEED
  endif
  ;-----------------------------------------------------------
; add fclass to transit links
  if(_factype=50-55 & _areatype=1-6)fclass=19   ;  Local transit routes - urban
  if(_factype=50-55 & _areatype=7)fclass=9    ;  Local transit routes - rural

  ;change ramp fclass to interstate
  IF(FACTYPE=7-9 & ATYPE=1-6) FCLASS=11
  IF(FACTYPE=7-9 & ATYPE=7) FCLASS=1
  
  ;-----------------------------------------------------------
  ; Add MOVES roadType
  ;-----------------------------------------------------------
  Lookup Name=_roadtype,
    Lookup[1]=1, Result=2,File=@RoadType@,
    Interpolate=n
  roadtype=_roadtype(1,fclass)
  
 IF (county=57,63,67,77,89,97,113,117,121,135,151,223,247)  ;Functional class corrections for 13 counties 
;  correct roadtype for centroid connectors with incorrect fclass
   IF(_factype=0)
       IF(_areatype=1-6)
           roadtype=5
       ENDIF
       IF(_areatype=7)
           roadtype=3
       ENDIF
   ENDIF
   IF(_factype=0 & _areatype=6 & li.1.fclass=19)
      roadtype=5
   ENDIF

;  correct Ronald Regan Parkway
   IF(factype=3 & fclass=14)
      roadtype=4
   ENDIF
;  Correct GA400
    IF(factype=1 & fclass=2 & atype=1-6)
      roadtype=4
    ENDIF
    IF(factype=1 & fclass=2 & atype=7)
      roadtype=2
    ENDIF
 ;  Correct links with fclass of 6,7,9 that should be urban
    IF(fclass=6-9 & atype=1-6)
      roadtype=5
    ENDIF
 ;  Correct frwy links
    IF(factype=1-4 & atype=1-6)
     roadtype=4
    ENDIF

   IF(FACTYPE=1-4)
    IF(COUNTY=63,67,89,121,135)
     roadtype=4
    ENDIF
   ENDIF

    
 ; Assign ramps to be Restricted Access because the HPMS codes
  ; for ramps is local which would assign an incorrect MOVES code
  IF(factype=7-9 & atype=1-6)
        roadtype=4
  ENDIF
  IF (factype=7-9 & atype=7)
        roadtype=2
  ENDIF
 ENDIF ;13 county if statement
 
 IF (county=13,15,45,139,217,255,297)  ;Fix ramps for the 7 counties
  IF(factype=7-9 & atype=1-6)
        roadtype=4
  ENDIF
  IF (factype=7-9 & atype=7)
        roadtype=2
  ENDIF
 ENDIF 

 
; add roadtype to transit links
  IF(_factype=50-99 & _areatype=1-6)roadtype=5 ;  Local transit routes - urban
  IF(_factype=50-99 & _areatype=7)roadtype=3   ;  Local transit routes - rural
 
;    Get HPMS vmt adjustment factor and apply to VMT
;
     _fclass=fclass
    Lookup Name=_HPMS,
    Lookup[1]=1, Result=2,File=@HPMSADJ@,
     Interpolate=n
       _HPMSadj=_HPMS(1,_fclass)

      print list=a(8),b(8),fclass(9.4),_fclass(9.4),_HPMSadj(9.4)

  LOOKUP LOOKUPI=1,
       NAME=HrPct_Period,
         LOOKUP[1]=HOUR, RESULT=PCTRT1,
         LOOKUP[2]=HOUR, RESULT=PCTRT2,
         LOOKUP[3]=HOUR, RESULT=PCTRT3,
         LOOKUP[4]=HOUR, RESULT=PCTRT4,
         LOOKUP[5]=HOUR, RESULT=PCTRT5,
       FAIL[1]=0,FAIL[2]=0,FAIL[3]=0

  ; Add transit volume to total volume by period
  trn_eahours=3 ; all hours
  trn_amhours=4 ; all hours
  trn_mdhours=5 ; all hours
  trn_pmhours=4 ; all hours
  trn_evhours=5 ; not all hours
  V_TRNEA=LI.2.TRN_HR*trn_eahours
  V_TRNAM=LI.3.TRN_HR*trn_amhours
  V_TRNMD=LI.4.TRN_HR*trn_mdhours
  V_TRNPM=LI.5.TRN_HR*trn_pmhours
  V_TRNEV=LI.6.TRN_HR*trn_evhours

  ; Sum Hwy and Transit Vehicles
  V_TOTEA=(V_EA+V_TRNEA)*_HPMSADJ
  V_TOTAM=(V_AM+V_TRNAM)*_HPMSADJ
  V_TOTMD=(V_MD+V_TRNMD)*_HPMSADJ
  V_TOTPM=(V_PM+V_TRNPM)*_HPMSADJ
  V_TOTEV=(V_EV+V_TRNEV)*_HPMSADJ

  ; HPMS Adjust Period Volumes and then include Transit Vehicles
  TOTEAVMTAdj=(V_TOTEA)*DISTANCE
  TOTAMVMTAdj=(V_TOTAM)*DISTANCE
  TOTMDVMTAdj=(V_TOTMD)*DISTANCE
  TOTPMVMTAdj=(V_TOTPM)*DISTANCE
  TOTEVVMTAdj=(V_TOTEV)*DISTANCE


  ; TOTAL VOLUME BY HOUR (Including Transit Vehicles)
  ; HR# is hour ending (i.e. HR1 = 12am to 1am)
;evening
  HR1 =V_TOTEV*HrPct_Period(roadtype,1)
  HR2 =V_TOTEV*HrPct_Period(roadtype,2)      
  HR3 =V_TOTEV*HrPct_Period(roadtype,3)
;early am
  HR4 =V_TOTEA*HrPct_Period(roadtype,4)
  HR5 =V_TOTEA*HrPct_Period(roadtype,5)
  HR6 =V_TOTEA*HrPct_Period(roadtype,6)
;am peak
  HR7 =V_TOTAM*HrPct_Period(roadtype,7)
  HR8 =V_TOTAM*HrPct_Period(roadtype,8)
  HR9 =V_TOTAM*HrPct_Period(roadtype,9)
  HR10=V_TOTAM*HrPct_Period(roadtype,10)
;midday
  HR11=V_TOTMD*HrPct_Period(roadtype,11)
  HR12=V_TOTMD*HrPct_Period(roadtype,12)
  HR13=V_TOTMD*HrPct_Period(roadtype,13)
  HR14=V_TOTMD*HrPct_Period(roadtype,14)
  HR15=V_TOTMD*HrPct_Period(roadtype,15)
;pm peak
  HR16=V_TOTPM*HrPct_Period(roadtype,16)
  HR17=V_TOTPM*HrPct_Period(roadtype,17)
  HR18=V_TOTPM*HrPct_Period(roadtype,18)
  HR19=V_TOTPM*HrPct_Period(roadtype,19)
;evening
  HR20=V_TOTEV*HrPct_Period(roadtype,20)
  HR21=V_TOTEV*HrPct_Period(roadtype,21)
  HR22=V_TOTEV*HrPct_Period(roadtype,22)
  HR23=V_TOTEV*HrPct_Period(roadtype,23)
  HR24=V_TOTEV*HrPct_Period(roadtype,24)

  _KEEP=0
  IF(@POL@=1-2) ;loops 1 & 2 are 13 county
    IF (county=57,63,67,77,89,97,113,117,121,135,151,223,247) _KEEP=1
  ELSEIF(@POL@=3-4)  ;loops 3 & 4 are 7 county
    IF (county=13,15,45,139,217,255,297) _KEEP=1
  ELSEIF(@POL@=5-6) ;loops 5 & 6 are 5 county
    IF (county=63,67,89,121,135) _KEEP=1
  ELSEIF(@POL@=7-8) ;loops 7 & 8 are 2 county
    IF (county=15,217) _KEEP=1
  ENDIF  
    
  IF (_KEEP=0) DELETE

  ; delete external station connectors
  if (a={ext1}-{ext2}|| b={ext1}-{ext2}) delete
  ; delete dummy links
  if (distance=0) delete
  ; delete transit only station connector links
  IF (FACTYPE=52,53,55,98) DELETE
ENDRUN

;===========================================================================================
; Calculate hourly time and speeds
;===========================================================================================
RUN PGM=HWYNET
  NETI="@Pollutant@\MOVES_HrVol.NET"
  NETO="@Pollutant@\MOVES_HrTime.NET"

 _eacap = EACAPACITY
 _amcap = AMCAPACITY
 _mdcap = MDCAPACITY
 _pmcap = PMCAPACITY
 _evcap = EVCAPACITY
 
    LOOKUP INTERPOLATE=T, NAME=PARAMS,     ;eqv. to speed curves in TRANPLAN setup
    LOOKUP[1] =1, RESULT=2,                 ;A
    LOOKUP[2] =1, RESULT=3,                 ;B
    LOOKUP[3] =1, RESULT=4,                 ;C
    LOOKUP[4] =1, RESULT=5,                 ;A1
    LOOKUP[5] =1, RESULT=6,                 ;B1
    LOOKUP[6] =1, RESULT=7,                 ;C1

;  LCLASS        A       B       C      A1      B1      C1
  R=	' 1 	 0.100 	 0.600 	 6.000 	 0.100 	 0.600   4.500 ' ,
	    ' 2 	 0.000 	 1.000 	 4.000 	 0.000 	 1.000 	 3.000 ' ,
	    ' 3 	 0.000 	 1.250 	 4.000 	 0.000 	 1.250 	 3.000 ' ,
	    ' 4 	 0.100 	 1.000 	 4.000 	 0.100 	 1.000 	 3.000 ' ,
	    ' 5 	 0.100 	 0.450 	 4.000 	 0.100 	 0.450 	 4.000 ' ,
	    ' 6 	 0.100 	 0.450 	 4.000 	 0.100 	 0.450 	 4.000 ' ,
	    ' 7 	 0.200 	 1.250 	 5.500 	 0.200 	 1.250 	 4.000 '

;FREEWAY
 IF(FACTYPE = 1,4,5,6) 
   IF(WEAVEFLAG=1)  ;set VDF class for links identified as weaving sections
    VDFCLASS=7
   ELSE
    VDFCLASS=1      ;set VDF class for basic links
   ENDIF 
; Expressway
 ELSEIF(FACTYPE=2)
   VDFCLASS=2
; Parkway
 ELSEIF(FACTYPE=3)
   VDFCLASS=3
; Ramps
 ELSEIF(FACTYPE=7-9)
   VDFCLASS=4
; Arterial    
 ELSEIF(FACTYPE=10-13)
   VDFCLASS=5
 ELSEIF(FACTYPE=14)
; Collector    
   VDFCLASS=6
 ENDIF

ATERM = PARAMS(1,VDFCLASS)
BTERM = PARAMS(2,VDFCLASS)
CTERM = PARAMS(3,VDFCLASS)
A1TERM = PARAMS(4,VDFCLASS)
B1TERM = PARAMS(5,VDFCLASS)
C1TERM = PARAMS(6,VDFCLASS)
     ; Congested Time by Hour

    ; manually set centroid connector speeds & time
    IF (FACTYPE=0)
      IF (ATYPE=1) _cspd=15
      IF (ATYPE=2) _cspd=18
      IF (ATYPE=3) _cspd=21
      IF (ATYPE=4) _cspd=24
      IF (ATYPE=5) _cspd=27
      IF (ATYPE=6) _cspd=30
      IF (ATYPE=7) _cspd=35
      TIME1=DISTANCE/_cspd*60
    ENDIF
    if (DISTANCE=0) TIME1=0.0001 ; dummy links
;    IF (FACTYPE=50 | FACTYPE=0)
    ctimehr1 =TIME1
    ctimehr2 =TIME1
    ctimehr3 =TIME1
    ctimehr4 =TIME1
    ctimehr5 =TIME1
    ctimehr6 =TIME1
    ctimehr7 =TIME1
    ctimehr8 =TIME1
    ctimehr9 =TIME1
    ctimehr10=TIME1
    ctimehr11=TIME1
    ctimehr12=TIME1
    ctimehr13=TIME1
    ctimehr14=TIME1
    ctimehr15=TIME1
    ctimehr16=TIME1
    ctimehr17=TIME1
    ctimehr18=TIME1
    ctimehr19=TIME1
    ctimehr20=TIME1
    ctimehr21=TIME1
    ctimehr22=TIME1
    ctimehr23=TIME1
    ctimehr24=TIME1


;HOURS 
IF (_EVCAP>0)
 ctimehr1 = CMPNUMRETNUM(HR1/_EVCAP,'<=',1,TIME1 * (1 + ATERM * HR1/_EVCAP + BTERM * ((HR1/_EVCAP)^CTERM)),TIME1 * (1 + A1TERM * HR1/_EVCAP + B1TERM * ((HR1/_EVCAP)^C1TERM)))
 ctimehr2 = CMPNUMRETNUM(HR2/_EVCAP,'<=',1,TIME1 * (1 + ATERM * HR2/_EVCAP + BTERM * ((HR2/_EVCAP)^CTERM)),TIME1 * (1 + A1TERM * HR2/_EVCAP + B1TERM * ((HR2/_EVCAP)^C1TERM)))
 ctimehr3 = CMPNUMRETNUM(HR3/_EVCAP,'<=',1,TIME1 * (1 + ATERM * HR3/_EVCAP + BTERM * ((HR3/_EVCAP)^CTERM)),TIME1 * (1 + A1TERM * HR3/_EVCAP + B1TERM * ((HR3/_EVCAP)^C1TERM)))
ENDIF
IF (_EACAP>0)
 ctimehr4 = CMPNUMRETNUM(HR4/_EACAP,'<=',1,TIME1 * (1 + ATERM * HR4/_EACAP + BTERM * ((HR4/_EACAP)^CTERM)),TIME1 * (1 + A1TERM * HR4/_EACAP + B1TERM * ((HR4/_EACAP)^C1TERM)))
 ctimehr5 = CMPNUMRETNUM(HR5/_EACAP,'<=',1,TIME1 * (1 + ATERM * HR5/_EACAP + BTERM * ((HR5/_EACAP)^CTERM)),TIME1 * (1 + A1TERM * HR5/_EACAP + B1TERM * ((HR5/_EACAP)^C1TERM)))
 ctimehr6 = CMPNUMRETNUM(HR6/_EACAP,'<=',1,TIME1 * (1 + ATERM * HR6/_EACAP + BTERM * ((HR6/_EACAP)^CTERM)),TIME1 * (1 + A1TERM * HR6/_EACAP + B1TERM * ((HR6/_EACAP)^C1TERM)))
ENDIF
IF (_AMCAP>0)
 ctimehr7 = CMPNUMRETNUM(HR7/_AMCAP,'<=',1,TIME1 * (1 + ATERM * HR7/_AMCAP + BTERM * ((HR7/_AMCAP)^CTERM)),TIME1 * (1 + A1TERM * HR7/_AMCAP + B1TERM * ((HR7/_AMCAP)^C1TERM)))
 ctimehr8 = CMPNUMRETNUM(HR8/_AMCAP,'<=',1,TIME1 * (1 + ATERM * HR8/_AMCAP + BTERM * ((HR8/_AMCAP)^CTERM)),TIME1 * (1 + A1TERM * HR8/_AMCAP + B1TERM * ((HR8/_AMCAP)^C1TERM)))
 ctimehr9 = CMPNUMRETNUM(HR9/_AMCAP,'<=',1,TIME1 * (1 + ATERM * HR9/_AMCAP + BTERM * ((HR9/_AMCAP)^CTERM)),TIME1 * (1 + A1TERM * HR9/_AMCAP + B1TERM * ((HR9/_AMCAP)^C1TERM)))
 ctimehr10= CMPNUMRETNUM(HR10/_AMCAP,'<=',1,TIME1 * (1 + ATERM * HR10/_AMCAP + BTERM * ((HR10/_AMCAP)^CTERM)),TIME1 * (1 + A1TERM * HR10/_AMCAP + B1TERM * ((HR10/_AMCAP)^C1TERM)))
ENDIF
IF (_MDCAP>0)
 ctimehr11= CMPNUMRETNUM(HR11/_MDCAP,'<=',1,TIME1 * (1 + ATERM * HR11/_MDCAP + BTERM * ((HR11/_MDCAP)^CTERM)),TIME1 * (1 + A1TERM * HR11/_MDCAP + B1TERM * ((HR11/_MDCAP)^C1TERM)))
 ctimehr12= CMPNUMRETNUM(HR12/_MDCAP,'<=',1,TIME1 * (1 + ATERM * HR12/_MDCAP + BTERM * ((HR12/_MDCAP)^CTERM)),TIME1 * (1 + A1TERM * HR12/_MDCAP + B1TERM * ((HR12/_MDCAP)^C1TERM)))
 ctimehr13= CMPNUMRETNUM(HR13/_MDCAP,'<=',1,TIME1 * (1 + ATERM * HR13/_MDCAP + BTERM * ((HR13/_MDCAP)^CTERM)),TIME1 * (1 + A1TERM * HR13/_MDCAP + B1TERM * ((HR13/_MDCAP)^C1TERM)))
 ctimehr14= CMPNUMRETNUM(HR14/_MDCAP,'<=',1,TIME1 * (1 + ATERM * HR14/_MDCAP + BTERM * ((HR14/_MDCAP)^CTERM)),TIME1 * (1 + A1TERM * HR14/_MDCAP + B1TERM * ((HR14/_MDCAP)^C1TERM)))
 ctimehr15= CMPNUMRETNUM(HR15/_MDCAP,'<=',1,TIME1 * (1 + ATERM * HR15/_MDCAP + BTERM * ((HR15/_MDCAP)^CTERM)),TIME1 * (1 + A1TERM * HR15/_MDCAP + B1TERM * ((HR15/_MDCAP)^C1TERM)))
ENDIF
IF (_PMCAP>0)
 ctimehr16= CMPNUMRETNUM(HR16/_PMCAP,'<=',1,TIME1 * (1 + ATERM * HR16/_PMCAP + BTERM * ((HR16/_PMCAP)^CTERM)),TIME1 * (1 + A1TERM * HR16/_PMCAP + B1TERM * ((HR16/_PMCAP)^C1TERM)))
 ctimehr17= CMPNUMRETNUM(HR17/_PMCAP,'<=',1,TIME1 * (1 + ATERM * HR17/_PMCAP + BTERM * ((HR17/_PMCAP)^CTERM)),TIME1 * (1 + A1TERM * HR17/_PMCAP + B1TERM * ((HR17/_PMCAP)^C1TERM)))
 ctimehr18= CMPNUMRETNUM(HR18/_PMCAP,'<=',1,TIME1 * (1 + ATERM * HR18/_PMCAP + BTERM * ((HR18/_PMCAP)^CTERM)),TIME1 * (1 + A1TERM * HR18/_PMCAP + B1TERM * ((HR18/_PMCAP)^C1TERM)))
 ctimehr19= CMPNUMRETNUM(HR19/_PMCAP,'<=',1,TIME1 * (1 + ATERM * HR19/_PMCAP + BTERM * ((HR19/_PMCAP)^CTERM)),TIME1 * (1 + A1TERM * HR19/_PMCAP + B1TERM * ((HR19/_PMCAP)^C1TERM)))
ENDIF
IF (_EVCAP>0)
 ctimehr20= CMPNUMRETNUM(HR20/_EVCAP,'<=',1,TIME1 * (1 + ATERM * HR20/_EVCAP + BTERM * ((HR20/_EVCAP)^CTERM)),TIME1 * (1 + A1TERM * HR20/_EVCAP + B1TERM * ((HR20/_EVCAP)^C1TERM)))
 ctimehr21= CMPNUMRETNUM(HR21/_EVCAP,'<=',1,TIME1 * (1 + ATERM * HR21/_EVCAP + BTERM * ((HR21/_EVCAP)^CTERM)),TIME1 * (1 + A1TERM * HR21/_EVCAP + B1TERM * ((HR21/_EVCAP)^C1TERM)))
 ctimehr22= CMPNUMRETNUM(HR22/_EVCAP,'<=',1,TIME1 * (1 + ATERM * HR22/_EVCAP + BTERM * ((HR22/_EVCAP)^CTERM)),TIME1 * (1 + A1TERM * HR22/_EVCAP + B1TERM * ((HR22/_EVCAP)^C1TERM)))
 ctimehr23= CMPNUMRETNUM(HR23/_EVCAP,'<=',1,TIME1 * (1 + ATERM * HR23/_EVCAP + BTERM * ((HR23/_EVCAP)^CTERM)),TIME1 * (1 + A1TERM * HR23/_EVCAP + B1TERM * ((HR23/_EVCAP)^C1TERM)))
 ctimehr24= CMPNUMRETNUM(HR24/_EVCAP,'<=',1,TIME1 * (1 + ATERM * HR24/_EVCAP + BTERM * ((HR24/_EVCAP)^CTERM)),TIME1 * (1 + A1TERM * HR24/_EVCAP + B1TERM * ((HR24/_EVCAP)^C1TERM)))
ENDIF

IF(FACTYPE=99) ;transit ROW links
 ctimehr1 = trntime
 ctimehr2 = trntime
 ctimehr3 = trntime
 ctimehr4 = trntime
 ctimehr5 = trntime
 ctimehr6 = trntime
 ctimehr7 = trntime
 ctimehr8 = trntime
 ctimehr9 = trntime
 ctimehr10 = trntime
 ctimehr11 = trntime
 ctimehr12 = trntime
 ctimehr13 = trntime
 ctimehr14 = trntime
 ctimehr15 = trntime
 ctimehr16 = trntime
 ctimehr17 = trntime
 ctimehr18 = trntime
 ctimehr19 = trntime
 ctimehr20 = trntime
 ctimehr21 = trntime
 ctimehr22 = trntime
 ctimehr23 = trntime
 ctimehr24 = trntime
ENDIF

    ; Congested Speed by Hour
    cspdhr1=distance/(ctimehr1/60)
    cspdhr2=distance/(ctimehr2/60)
    cspdhr3=distance/(ctimehr3/60)
    cspdhr4=distance/(ctimehr4/60)
    cspdhr5=distance/(ctimehr5/60)
    cspdhr6=distance/(ctimehr6/60)
    cspdhr7=distance/(ctimehr7/60)
    cspdhr8=distance/(ctimehr8/60)
    cspdhr9=distance/(ctimehr9/60)
    cspdhr10=distance/(ctimehr10/60)
    cspdhr11=distance/(ctimehr11/60)
    cspdhr12=distance/(ctimehr12/60)
    cspdhr13=distance/(ctimehr13/60)
    cspdhr14=distance/(ctimehr14/60)
    cspdhr15=distance/(ctimehr15/60)
    cspdhr16=distance/(ctimehr16/60)
    cspdhr17=distance/(ctimehr17/60)
    cspdhr18=distance/(ctimehr18/60)
    cspdhr19=distance/(ctimehr19/60)
    cspdhr20=distance/(ctimehr20/60)
    cspdhr21=distance/(ctimehr21/60)
    cspdhr22=distance/(ctimehr22/60)
    cspdhr23=distance/(ctimehr23/60)
    cspdhr24=distance/(ctimehr24/60)

;   Calculate Speed Bin for link by hour
    Lookup Name=_spd,
    Lookup[1]=1, Result=2,File=@speedbin@,
      setupper=t
     spdbinhr1=_spd(1,cspdhr1)
     spdbinhr2=_spd(1,cspdhr2)
     spdbinhr3=_spd(1,cspdhr3)
     spdbinhr4=_spd(1,cspdhr4)
     spdbinhr5=_spd(1,cspdhr5)
     spdbinhr6=_spd(1,cspdhr6)
     spdbinhr7=_spd(1,cspdhr7)
     spdbinhr8=_spd(1,cspdhr8)
     spdbinhr9=_spd(1,cspdhr9)
     spdbinhr10=_spd(1,cspdhr10)
     spdbinhr11=_spd(1,cspdhr11)
     spdbinhr12=_spd(1,cspdhr12)
     spdbinhr13=_spd(1,cspdhr13)
     spdbinhr14=_spd(1,cspdhr14)
     spdbinhr15=_spd(1,cspdhr15)
     spdbinhr16=_spd(1,cspdhr16)
     spdbinhr17=_spd(1,cspdhr17)
     spdbinhr18=_spd(1,cspdhr18)
     spdbinhr19=_spd(1,cspdhr19)
     spdbinhr20=_spd(1,cspdhr20)
     spdbinhr21=_spd(1,cspdhr21)
     spdbinhr22=_spd(1,cspdhr22)
     spdbinhr23=_spd(1,cspdhr23)
     spdbinhr24=_spd(1,cspdhr24)
ENDRUN
*del @Pollutant@\SpeedFractions.txt

LOOP RDTYPE=2,5
 LOOP HR=1,24

RUN PGM=NETWORK
  NETI="@Pollutant@\MOVES_HrTime.NET"

  IF(ROADTYPE = @RDTYPE@)
  IF(SPDBINHR@HR@ = 1)
   _VHT1 = _VHT1 + HR@HR@ * CTIMEHR@HR@ / 60
  ELSEIF(SPDBINHR@HR@ = 2)
   _VHT2 = _VHT2 + HR@HR@ * CTIMEHR@HR@ / 60
  ELSEIF(SPDBINHR@HR@ = 3)
   _VHT3 = _VHT3 + HR@HR@ * CTIMEHR@HR@ / 60
  ELSEIF(SPDBINHR@HR@ = 4)
   _VHT4 = _VHT4 + HR@HR@ * CTIMEHR@HR@ / 60
  ELSEIF(SPDBINHR@HR@ = 5)
   _VHT5 = _VHT5 + HR@HR@ * CTIMEHR@HR@ / 60
  ELSEIF(SPDBINHR@HR@ = 6)
   _VHT6 = _VHT6 + HR@HR@ * CTIMEHR@HR@ / 60
  ELSEIF(SPDBINHR@HR@ = 7)
   _VHT7 = _VHT7 + HR@HR@ * CTIMEHR@HR@ / 60
  ELSEIF(SPDBINHR@HR@ = 8)
   _VHT8 = _VHT8 + HR@HR@ * CTIMEHR@HR@ / 60
  ELSEIF(SPDBINHR@HR@ = 9)
   _VHT9 = _VHT9 + HR@HR@ * CTIMEHR@HR@ / 60
  ELSEIF(SPDBINHR@HR@ = 10)
   _VHT10 = _VHT10 + HR@HR@ * CTIMEHR@HR@ / 60
  ELSEIF(SPDBINHR@HR@ = 11)
   _VHT11 = _VHT11 + HR@HR@ * CTIMEHR@HR@ / 60
  ELSEIF(SPDBINHR@HR@ = 12)
   _VHT12 = _VHT12 + HR@HR@ * CTIMEHR@HR@ / 60
  ELSEIF(SPDBINHR@HR@ = 13)
   _VHT13 = _VHT13 + HR@HR@ * CTIMEHR@HR@ / 60
  ELSEIF(SPDBINHR@HR@ = 14)
   _VHT14 = _VHT14 + HR@HR@ * CTIMEHR@HR@ / 60
  ELSEIF(SPDBINHR@HR@ = 15)
   _VHT15 = _VHT15 + HR@HR@ * CTIMEHR@HR@ / 60
  ELSEIF(SPDBINHR@HR@ = 16)
   _VHT16 = _VHT16 + HR@HR@ * CTIMEHR@HR@ / 60
  ENDIF
 ENDIF
PHASE=SUMMARY
 _TOTVHT = _VHT1 + _VHT2 + _VHT3 + _VHT4 + _VHT5 + _VHT6 + _VHT7 + _VHT8 +
           _VHT9 + _VHT10 + _VHT11 + _VHT12 + _VHT13 + _VHT14 + _VHT15 + _VHT16
 _SB1 = ROUND(_VHT1 / _TOTVHT * 100000)/100000
 _SB2 = ROUND(_VHT2 / _TOTVHT * 100000)/100000
 _SB3 = ROUND(_VHT3 / _TOTVHT * 100000)/100000
 _SB4 = ROUND(_VHT4 / _TOTVHT * 100000)/100000
 _SB5 = ROUND(_VHT5 / _TOTVHT * 100000)/100000
 _SB6 = ROUND(_VHT6 / _TOTVHT * 100000)/100000
 _SB7 = ROUND(_VHT7 / _TOTVHT * 100000)/100000
 _SB8 = ROUND(_VHT8 / _TOTVHT * 100000)/100000
 _SB9 = ROUND(_VHT9 / _TOTVHT * 100000)/100000
 _SB10 = ROUND(_VHT10 / _TOTVHT * 100000)/100000
 _SB11 = ROUND(_VHT11 / _TOTVHT * 100000)/100000
 _SB12 = ROUND(_VHT12 / _TOTVHT * 100000)/100000
 _SB13 = ROUND(_VHT13 / _TOTVHT * 100000)/100000
 _SB14 = ROUND(_VHT14 / _TOTVHT * 100000)/100000
 _SB15 = ROUND(_VHT15 / _TOTVHT * 100000)/100000
 _SB16 = ROUND(_VHT16 / _TOTVHT * 100000)/100000

 ; Ensure rounded speed bin fractions sum to one
 _sum=_SB1+_SB2+_SB3+_SB4+_SB5+_SB6+_SB7+_SB8+_SB9+_SB10+_SB11+_SB12+_SB13+_SB14+_SB15+_SB16
 _diff=1-_sum
 ; start from the highest bin and work backwords to find a bin
 ; that can be adjusted without becoming less than zero
 if (_SB16>abs(_diff))
   _SB16=_SB16+_diff
 elseif (_SB15>abs(_diff))
   _SB15=_SB15+_diff
 elseif (_SB14>abs(_diff))
   _SB14=_SB14+_diff
 elseif (_SB13>abs(_diff))
   _SB13=_SB13+_diff
 elseif (_SB12>abs(_diff))
   _SB12=_SB12+_diff
 elseif (_SB11>abs(_diff))
   _SB11=_SB11+_diff
 elseif (_SB10>abs(_diff))
   _SB10=_SB10+_diff
 elseif (_SB9>abs(_diff))
   _SB9=_SB9+_diff
 elseif (_SB8>abs(_diff))
   _SB8=_SB8+_diff
 elseif (_SB7>abs(_diff))
   _SB7=_SB7+_diff
 elseif (_SB6>abs(_diff))
   _SB6=_SB6+_diff
 elseif (_SB5>abs(_diff))
   _SB5=_SB5+_diff
 elseif (_SB4>abs(_diff))
   _SB4=_SB4+_diff
 elseif (_SB3>abs(_diff))
   _SB3=_SB3+_diff
 elseif (_SB2>abs(_diff))
   _SB2=_SB2+_diff
 else
   _SB1=_SB1+_diff
 endif

LOOP _SOURCE=1,13
 IF (_SOURCE=1)
  SOURCEID = 11
 ELSEIF (_SOURCE=2)
  SOURCEID = 21
 ELSEIF (_SOURCE=3)
  SOURCEID = 31
 ELSEIF (_SOURCE=4)
  SOURCEID = 32
 ELSEIF (_SOURCE=5)
  SOURCEID = 41
 ELSEIF (_SOURCE=6)
  SOURCEID = 42
 ELSEIF (_SOURCE=7)
  SOURCEID = 43
 ELSEIF (_SOURCE=8)
  SOURCEID = 51
 ELSEIF (_SOURCE=9)
  SOURCEID = 52
 ELSEIF (_SOURCE=10)
  SOURCEID = 53
 ELSEIF (_SOURCE=11)
  SOURCEID = 54
 ELSEIF (_SOURCE=12)
  SOURCEID = 61
 ELSEIF (_SOURCE=13)
  SOURCEID = 62
 ENDIF

 PRINT FORM=5.0,LIST=SOURCEID,@RDTYPE@,@HR@,'5','    1',_SB1(10.5),FILE=@Pollutant@\SpeedFractions.txt,APPEND=T
 PRINT FORM=5.0,LIST=SOURCEID,@RDTYPE@,@HR@,'5','    2',_SB2(10.5),FILE=@Pollutant@\SpeedFractions.txt,APPEND=T
 PRINT FORM=5.0,LIST=SOURCEID,@RDTYPE@,@HR@,'5','    3',_SB3(10.5),FILE=@Pollutant@\SpeedFractions.txt,APPEND=T
 PRINT FORM=5.0,LIST=SOURCEID,@RDTYPE@,@HR@,'5','    4',_SB4(10.5),FILE=@Pollutant@\SpeedFractions.txt,APPEND=T
 PRINT FORM=5.0,LIST=SOURCEID,@RDTYPE@,@HR@,'5','    5',_SB5(10.5),FILE=@Pollutant@\SpeedFractions.txt,APPEND=T
 PRINT FORM=5.0,LIST=SOURCEID,@RDTYPE@,@HR@,'5','    6',_SB6(10.5),FILE=@Pollutant@\SpeedFractions.txt,APPEND=T
 PRINT FORM=5.0,LIST=SOURCEID,@RDTYPE@,@HR@,'5','    7',_SB7(10.5),FILE=@Pollutant@\SpeedFractions.txt,APPEND=T
 PRINT FORM=5.0,LIST=SOURCEID,@RDTYPE@,@HR@,'5','    8',_SB8(10.5),FILE=@Pollutant@\SpeedFractions.txt,APPEND=T
 PRINT FORM=5.0,LIST=SOURCEID,@RDTYPE@,@HR@,'5','    9',_SB9(10.5),FILE=@Pollutant@\SpeedFractions.txt,APPEND=T
 PRINT FORM=5.0,LIST=SOURCEID,@RDTYPE@,@HR@,'5','   10',_SB10(10.5),FILE=@Pollutant@\SpeedFractions.txt,APPEND=T
 PRINT FORM=5.0,LIST=SOURCEID,@RDTYPE@,@HR@,'5','   11',_SB11(10.5),FILE=@Pollutant@\SpeedFractions.txt,APPEND=T
 PRINT FORM=5.0,LIST=SOURCEID,@RDTYPE@,@HR@,'5','   12',_SB12(10.5),FILE=@Pollutant@\SpeedFractions.txt,APPEND=T
 PRINT FORM=5.0,LIST=SOURCEID,@RDTYPE@,@HR@,'5','   13',_SB13(10.5),FILE=@Pollutant@\SpeedFractions.txt,APPEND=T
 PRINT FORM=5.0,LIST=SOURCEID,@RDTYPE@,@HR@,'5','   14',_SB14(10.5),FILE=@Pollutant@\SpeedFractions.txt,APPEND=T
 PRINT FORM=5.0,LIST=SOURCEID,@RDTYPE@,@HR@,'5','   15',_SB15(10.5),FILE=@Pollutant@\SpeedFractions.txt,APPEND=T
 PRINT FORM=5.0,LIST=SOURCEID,@RDTYPE@,@HR@,'5','   16',_SB16(10.5),FILE=@Pollutant@\SpeedFractions.txt,APPEND=T

ENDLOOP ; _SOURCE
ENDPHASE
ENDRUN


 ENDLOOP   ;HR
ENDLOOP    ;RDTYPE

;REMOVE EMPTY LINES OF DATA FROM APPENDING TEXT FILE
RUN PGM=MATRIX
DBI[1]=@Pollutant@\SpeedFractions.txt,source=1,rdtype=2,hourday=3,spdbin=4,spdfrac=5
RECO[1]=@Pollutant@\SPEEDFRACTIONS.TMP,FIELDS=source,rdType,hourDay,SpeedBin,SpeedFrac(10.5)

ZONES=1

 LOOP K=1,DBI.1.NUMRECORDS
  X=DBIREADRECORD(1,K)
 IF(DI.1.SOURCE>0)
  RO.source = DI.1.SOURCE
  RO.rdType = DI.1.RDTYPE
  RO.hourDay = DI.1.HOURDAY
  RO.SpeedBin = DI.1.SPDBIN
  RO.SpeedFrac = DI.1.SPDFRAC
  WRITE RECO=1
 ENDIF
 ENDLOOP
ENDRUN

;SORT SPEED FRACTIONS FOR INPUT TO MOVES
;Normalize Speed Fractions by each SourceType, RoadType and hourDay combination
RUN PGM=MATRIX
DBI[1]=@Pollutant@\SpeedFractions.tmp,SORT=rdType,hourDay,SpeedBin,source
RECO[1]=@Pollutant@\AverageSpeedDistribution.dbf,FIELDS=sourceID(10.0),rdTypeID(10.0),hourDayID(10.0),AvgSpeedBin(10.0),AvgSpeedFra(10.5)

ZONES=1

 LOOP K=1,DBI.1.NUMRECORDS
  X=DBIREADRECORD(1,K)
  RO.sourceID = DI.1.source
  RO.rdTypeID = DI.1.rdType
  RO.hourDayID = DI.1.hourDay
  RO.AvgSpeedBin = DI.1.SpeedBin
  RO.AvgSpeedFra = DI.1.SpeedFrac
  WRITE RECO=1
 ENDLOOP
ENDRUN
RUN PGM=MATRIX
RECI=@Pollutant@\AverageSpeedDistribution.dbf
PRINTO[1]=@Pollutant@\AverageSpeedDistribution.csv

  sourceID = RI.sourceID
  rdTypeID = RI.rdTypeID
  hourDayID = RI.hourDayID
  AvgSpeedBinID = RI.AvgSpeedBin
  AvgSpeedFraction = RI.AvgSpeedFra
  if(reci.recno=1) print list='sourceTypeid,roadTypeID,hourDayID,AvgSpeedBinID,AvgSpeedFraction',printo=1
  Print csv=t,list=sourceid(4),rdTypeID(4),hourdayID(4),avgSpeedBinID(4),AvgSpeedFraction(10.5),printo=1

ENDRUN
*copy @Pollutant@\AverageSpeedDistribution.csv @Pollutant@\MOVESInputs\AverageSpeedDistribution_@Pollutant@.csv


;========================================================================================
;
;    This section summarizes the TDM model output for input into MOVES
;       Ramp VHT fractions
;       VHT fractions by Roadtype Unadjusted and Adjusted for HPMS Factors
;    Output is Ramp_vHt.rpt for the user to review
;       Total VHT
;
;========================================================================================
;,
run pgm=hwynet
 neti=@Pollutant@\MOVES_HRTIME.net
;compute hourly vht and sum
 VHT1 = HR1*CTIMEHR1/60 
 VHT2 = HR2*CTIMEHR2/60 
 VHT3 = HR3*CTIMEHR3/60 
 VHT4 = HR4*CTIMEHR4/60 
 VHT5 = HR5*CTIMEHR5/60 
 VHT6 = HR6*CTIMEHR6/60 
 VHT7 = HR7*CTIMEHR7/60 
 VHT8 = HR8*CTIMEHR8/60 
 VHT9 = HR9*CTIMEHR9/60 
 VHT10 = HR10*CTIMEHR10/60 
 VHT11 = HR11*CTIMEHR11/60 
 VHT12 = HR12*CTIMEHR12/60 
 VHT13 = HR13*CTIMEHR13/60 
 VHT14 = HR14*CTIMEHR14/60 
 VHT15 = HR15*CTIMEHR15/60 
 VHT16 = HR16*CTIMEHR16/60 
 VHT17 = HR17*CTIMEHR17/60 
 VHT18 = HR18*CTIMEHR18/60 
 VHT19 = HR19*CTIMEHR19/60 
 VHT20 = HR20*CTIMEHR20/60 
 VHT21 = HR21*CTIMEHR21/60 
 VHT22 = HR22*CTIMEHR22/60 
 VHT23 = HR23*CTIMEHR23/60 
 VHT24 = HR24*CTIMEHR24/60 
 VHTADJ = VHT1+VHT2+VHT3+VHT4+VHT5+VHT6+VHT7+VHT8+VHT9+VHT10+VHT11+VHT12+VHT13+VHT14+VHT15+VHT16+VHT17+VHT18+VHT19+VHT20+VHT21+VHT22+VHT23+VHT24
 
  if(factype=1-9)                                            ;Summarize Total frwy vht plus ramps
    _totfrwyvhtadj=_totfrwyvhtadj+VHTADJ                               ;HPMS adjusted 
    _totfrwyvht=_totfrwyvht+vht                                        ;Non HPMS adjusted
  endif
  if(factype=7-9)                                             ;Summarize Total entrance & exit ramp vht
    _totrampvhtadj=_totrampvhtadj+VHTADJ                               ;HPMS adjusted 
    _totrampvht=_totrampvht+vht                                        ;Non HPMS adjusted
  endif

  if(factype=1-9 && roadtype=2)                                            ;Summarize Total frwy vht plus ramps - rural
    _tfrwyruvhtadj=_tfrwyruvhtadj+VHTADJ                               ;HPMS adjusted 
    _tfrwyruvht=_tfrwyruvht+vht                                        ;Non HPMS adjusted
  endif
  if(factype=7-9 && roadtype=2)                                             ;Summarize Total entrance & exit ramp vht - rural
    _trmpruvhtadj=_trmpruvhtadj+VHTADJ                               ;HPMS adjusted 
    _trmpruvht=_trmpruvht+vht                                        ;Non HPMS adjusted
  endif

   if(factype=1-9 && roadtype=4)                                            ;Summarize Total frwy vht plus ramps - urban
    _tfrwyubvhtadj=_tfrwyubvhtadj+VHTADJ                               ;HPMS adjusted 
    _tfrwyubvht=_tfrwyubvht+vht                                        ;Non HPMS adjusted
  endif
  if(factype=7-9 && roadtype=4)                                             ;Summarize Total entrance & exit ramp vht - urban
    _trmpubvhtadj=_trmpubvhtadj+VHTADJ                               ;HPMS adjusted 
    _trmpubvht=_trmpubvht+vht                                        ;Non HPMS adjusted
  endif
   
 _totvhtadj=_totvhtadj+VHTADJ                               ;Total HPMS Adjusted VhT
 _totvht=_totvht+vht                                        ;Total Model Unadjusted VhT

    if(roadtype=2)
      _totvhtrur2adj=_totvhtrur2adj+VHTADJ                                ;Total HPMS Adjusted VhT
       _totvhtrur2=_totvhtrur2+vht                                        ;Total Model Unadjusted VhT

         if(factype=7-9)                       ;Ramps
          _rampvhtadjrur=_rampvhtadjrur+VHTADJ               ;Total HPMS Adjusted VhT for Ramps
          _rampvhtrural=_rampvhtrural+vht                    ;Total Model Unadjusted VhT for Ramps
         else
         endif
      else
     endif

    if(roadtype=3)
      _totvhtrur3adj=_totvhtrur3adj+VHTADJ                                ;Total HPMS Adjusted Vht
       _totvhtrur3=_totvhtrur3+vht                                        ;Total Model Unadjusted Vht
    endif

    if(roadtype=4)
      _totvhturb4adj=_totvhturb4adj+VHTADJ                                ;Total HPMS Adjusted Vht
       _totvhturb4=_totvhturb4+vht                                        ;Total Model Unadjusted Vht
         if(factype=7-9)                       ;Ramps
          _rampvhtadjurb=_rampvhtadjurb+VHTADJ              ;Total HPMS Adjusted Vht for Ramps
         _rampvhturban=_rampvhturban+vht                    ;Total Model Unadjusted Vht for Ramps
         else
         endif
     else     
    endif

    if(roadtype=5)
      _totvhturb5adj=_totvhturb5adj+VHTADJ                                ;Total HPMS Adjusted Vht
       _totvhturb5=_totvhturb5+vht                                        ;Total Model Unadjusted Vht
     else     
    endif

phase=summary
    if(_ramvhtadjrur>0)
        _pctrampadjrur=(_rampvhtadjrur/_totvhtruraladj)*100   ;Rural Restricted
        _pctramprural=(_rampvhtrural/_totvhtrural)*100
     endif
     if(_rampvhtadjurb>0)
        _pctrampadjurb=(_rampvhtadjurb/_totvhturbanadj)*100   ;Urban Restricted Access
        _pctrampurban=(_rampvhturban/_totvhturban)*100
    endif

    if(_tfrwyruvhtadj>0)                                  ;Rural
        _pctrurampadj=(_trmpruvhtadj/_tfrwyruvhtadj)*100   ;Percent ramp vht HPMS adj
        _pctruramp=(_trmpruvht/_tfrwyruvht)*100            ;Percent ramp vht unadjusted
    endif

    if(_tfrwyubvhtadj>0)                                  ;Urban
        _pctubrampadj=(_trmpubvhtadj/_tfrwyubvhtadj)*100   ;Percent ramp vht HPMS adj
        _pctubramp=(_trmpubvht/_tfrwyubvht)*100            ;Percent ramp vht unadjusted

        _pcttrampadj=((_trmpruvhtadj+_trmpubvhtadj)/(_tfrwyruvhtadj+_tfrwyubvhtadj))*100
        _pcttramp=((_trmpruvht+_trmpubvht)/(_tfrwyruvht+_tfrwyubvht))*100
 
    endif

if(1=1)
  print list='            ',file=@Pollutant@\ramp_vht.rpt
  print list='   Total Freeway and Ramp VHT by Urban/Rural      ',file=@Pollutant@\ramp_vht.rpt
  print list='        for Atlanta for ',{year4d}(4),file=@Pollutant@\ramp_vht.rpt
  print list='            ',file=@Pollutant@\ramp_vht.rpt
  print list='Urban VHT (Road Type=4) HPMS Adjusted         Non-Adjusted',file=@Pollutant@\ramp_vht.rpt
  print list='  Total Freeway          ',_tfrwyubvhtadj(12.1C),'         ',_tfrwyubvht(12.1C),file=@Pollutant@\ramp_vht.rpt
  print list='  Ramp                   ',_trmpubvhtadj(12.1C),'         ',_trmpubvht(12.1C),file=@Pollutant@\ramp_vht.rpt
  print list='  Percent Ramp VHT         ',_pctubrampadj(10.2),'           ',_pctubramp(10.2),file=@Pollutant@\ramp_vht.rpt
  print list='            ',file=@Pollutant@\ramp_vht.rpt
  print list='Rural VHT (Road Type=2) HPMS Adjusted         Non-Adjusted',file=@Pollutant@\ramp_vht.rpt
  print list='  Total Freeway          ',_tfrwyruvhtadj(12.1C),'         ',_tfrwyruvht(12.1C),file=@Pollutant@\ramp_vht.rpt
  print list='  Ramp                   ',_trmpruvhtadj(12.1C),'         ',_trmpruvht(12.1C),file=@Pollutant@\ramp_vht.rpt
  print list='  Percent Ramp VHT         ',_pctrurampadj(10.2),'           ',_pctruramp(10.2),file=@Pollutant@\ramp_vht.rpt
  print list='            ',file=@Pollutant@\ramp_vht.rpt
  print list='Total VHT               HPMS Adjusted         Non-Adjusted',file=@Pollutant@\ramp_vht.rpt
  print list='  Total Freeway          ',(_tfrwyruvhtadj+_tfrwyubvhtadj)(12.1C),'         ',(_tfrwyruvht+_tfrwyubvht)(12.1C),file=@Pollutant@\ramp_vht.rpt
  print list='  Ramp                   ',(_trmpruvhtadj+_trmpubvhtadj)(12.1C),'         ',(_trmpruvht+_trmpubvht)(12.1C),file=@Pollutant@\ramp_vht.rpt
  print list='  Percent Ramp VHT         ',_pcttrampadj(10.2),'           ',_pcttramp(10.2),file=@Pollutant@\ramp_vht.rpt

;     Print to a CSV file
  print csv=t,list='roadTypeID,RampFraction',file=@Pollutant@\Rampfraction.csv
  Print csv=t,list='2',(_pctrurampadj/100)(8.4),file=@Pollutant@\Rampfraction.csv
  Print csv=t,list='4',(_pctubrampadj)/100(8.4),file=@Pollutant@\Rampfraction.csv

endif

endphase

endrun
*copy @Pollutant@\Rampfraction.csv  @Pollutant@\MOVESInputs\Rampfraction_@Pollutant@.csv
;    This script produces the VehicleTypeVmt in both text and csv format for input to MOVES
;      Summarize VMT from the model by road type, factor the VMT by the GDOT HPMS Fractions
;        Then Redistribute the VMT for Vehicle Types 20 and 30 based on MOVES National Defaults
;
RUN PGM=NETWORK
  NETI=@Pollutant@\MOVES_HRVOL.NET    ;  LOADED HIGHWAY NETWORK 24-HR (SUM OF PERIODS)
  if((li.1.a={ext1}-{ext2}) || (li.1.b={ext1}-{ext2}))break     ;eliminate external station links

      _vmttmp=(toteavmtadj+totamvmtadj+totmdvmtadj+totpmvmtadj+totevvmtadj)

     _tvmt=_tvmt+_vmttmp
 _VMT1 = 0
IF(ROADTYPE = 2)
 _VMT2 = _VMT2 + _vmttmp 
;  PRINT LIST=A(8),B(8),ROADTYPE(4),_VMTTMP(9.4)
ELSEIF(ROADTYPE = 3)
 _VMT3 = _VMT3 + _vmttmp 
ELSEIF(ROADTYPE = 4)
 _VMT4 = _VMT4 + _vmttmp
ELSEIF(ROADTYPE = 5)
 _VMT5 = _VMT5 + _vmttmp
ENDIF

PHASE=SUMMARY

 _VMT2FRAC=_VMT2/_TVMT
 _VMT3FRAC=_VMT3/_TVMT
 _VMT4FRAC=_VMT4/_TVMT
 _VMT5FRAC=_VMT5/_TVMT
ENDPHASE
 LOG VAR=_TVMT
 LOG VAR=_VMT2FRAC
 LOG VAR=_VMT3FRAC
 LOG VAR=_VMT4FRAC
 LOG VAR=_VMT5FRAC

ENDRUN
RUN PGM=MATRIX
 ZONES=1
      _roadtype2=2
      _roadtype3=3
      _roadtype4=4
      _roadtype5=5

  Lookup Name=_fact10,              ;vehicle  type 10
    Lookup[1]=1,Result=2,File=@GDOTHPMS@,
     Interpolate=n
     _rd2factor10=_fact10(1,_roadtype2)
     _rd3factor10=_fact10(1,_roadtype3)
     _rd4factor10=_fact10(1,_roadtype4)
     _rd5factor10=_fact10(1,_roadtype5)

 print list=_rd2factor10(10.8),_rd3factor10(10.8),_rd4factor10(10.8),_rd5factor10(10.8)

  Lookup Name=_fact25,             ;vehicle type 25
    Lookup[1]=1,Result=3,File=@GDOTHPMS@,
     Interpolate=n
     _rd2factor25=_fact25(1,_roadtype2)
     _rd3factor25=_fact25(1,_roadtype3)
     _rd4factor25=_fact25(1,_roadtype4)
     _rd5factor25=_fact25(1,_roadtype5)
 
;  Lookup Name=_fact20,             ;vehicle type 20
;    Lookup[1]=1,Result=3,File=@GDOTHPMS@,
;     Interpolate=n
;     _rd2factor20=_fact20(1,_roadtype2)
;     _rd3factor20=_fact20(1,_roadtype3)
;     _rd4factor20=_fact20(1,_roadtype4)
;     _rd5factor20=_fact20(1,_roadtype5)

;  Lookup Name=_fact30,             ;vehicle type 30
;    Lookup[1]=1,Result=4,File=@GDOTHPMS@,
;     Interpolate=n
;     _rd2factor30=_fact30(1,_roadtype2)
;     _rd3factor30=_fact30(1,_roadtype3)
;     _rd4factor30=_fact30(1,_roadtype4)
;     _rd5factor30=_fact30(1,_roadtype5)

  Lookup Name=_fact40,             ;vehicle type 40
    Lookup[1]=1,Result=4,File=@GDOTHPMS@,
     Interpolate=n
     _rd2factor40=_fact40(1,_roadtype2)
     _rd3factor40=_fact40(1,_roadtype3)
     _rd4factor40=_fact40(1,_roadtype4)
     _rd5factor40=_fact40(1,_roadtype5)

  Lookup Name=_fact50,             ;vehicle type 50
    Lookup[1]=1,Result=5,File=@GDOTHPMS@,
     Interpolate=n
     _rd2factor50=_fact50(1,_roadtype2)
     _rd3factor50=_fact50(1,_roadtype3)
     _rd4factor50=_fact50(1,_roadtype4)
     _rd5factor50=_fact50(1,_roadtype5)

  Lookup Name=_fact60,             ;vehicle type 60
    Lookup[1]=1,Result=6,File=@GDOTHPMS@,
     Interpolate=n
     _rd2factor60=_fact60(1,_roadtype2)
     _rd3factor60=_fact60(1,_roadtype3)
     _rd4factor60=_fact60(1,_roadtype4)
     _rd5factor60=_fact60(1,_roadtype5)


;Get MOVES default fractions to redistribute 20 and 30
        _year=int({year4d})

;  Lookup Name=_moves25,             
;    Lookup[1]=1,Result=3,File=@hpmsbyyear@,
;     Interpolate=n
;     _rdMoves25=_moves25(1,_year)
        

;     _tmoves=_rdmoves20+_rdmoves30
;     _movespct20=_rdmoves20/_tmoves
;     _movespct30=_rdmoves30/_tmoves

 ;     _adjrd2_20=(_rd2factor20+_rd2factor30)*_movespct20
 ;     _adjrd2_30=(_rd2factor20+_rd2factor30)*_movespct30
 ;     _adjrd3_20=(_rd3factor20+_rd3factor30)*_movespct20
 ;     _adjrd3_30=(_rd3factor20+_rd3factor30)*_movespct30
 ;     _adjrd4_20=(_rd4factor20+_rd4factor30)*_movespct20
 ;     _adjrd4_30=(_rd4factor20+_rd4factor30)*_movespct30
 ;     _adjrd5_20=(_rd5factor20+_rd5factor30)*_movespct20
 ;     _adjrd5_30=(_rd5factor20+_rd5factor30)*_movespct30

;     print list= _rdmoves20(10.4),_rdmoves30(10.4),_tmoves,_movespct20(8.4),_movespct30(8.4),_adjrd2_20(8.4),_adjrd2_30(8.4)

   _vmt10f=(((@network._vmt2frac@*_rd2factor10)+(@network._vmt3frac@*_rd3factor10)+(@network._vmt4frac@*_rd4factor10)+(@network._vmt5frac@*_rd5factor10)))
;   _vmt20f=(((@network._vmt2frac@*_adjrd2_20)+(@network._vmt3frac@*_adjrd3_20)+(@network._vmt4frac@*_adjrd4_20)+(@network._vmt5frac@*_adjrd5_20)))
;   _vmt30f=(((@network._vmt2frac@*_adjrd2_30)+(@network._vmt3frac@*_adjrd3_30)+(@network._vmt4frac@*_adjrd4_30)+(@network._vmt5frac@*_adjrd5_30)))
   _vmt25f=(((@network._vmt2frac@*_rd2factor25)+(@network._vmt3frac@*_rd3factor25)+(@network._vmt4frac@*_rd4factor25)+(@network._vmt5frac@*_rd5factor25)))
   _vmt40f=(((@network._vmt2frac@*_rd2factor40)+(@network._vmt3frac@*_rd3factor40)+(@network._vmt4frac@*_rd4factor40)+(@network._vmt5frac@*_rd5factor40)))
   _vmt50f=(((@network._vmt2frac@*_rd2factor50)+(@network._vmt3frac@*_rd3factor50)+(@network._vmt4frac@*_rd4factor50)+(@network._vmt5frac@*_rd5factor50)))
   _vmt60f=(((@network._vmt2frac@*_rd2factor60)+(@network._vmt3frac@*_rd3factor60)+(@network._vmt4frac@*_rd4factor60)+(@network._vmt5frac@*_rd5factor60)))

   _vmt10=_vmt10f*@network._tvmt@
;   _vmt20=_vmt20f*@network._tvmt@
;   _vmt30=_vmt30f*@network._tvmt@
   _vmt25=_vmt25f*@network._tvmt@
   _vmt40=_vmt40f*@network._tvmt@
   _vmt50=_vmt50f*@network._tvmt@
   _vmt60=_vmt60f*@network._tvmt@

   print list='1  ',_vmt60,file=@Pollutant@\vmt60.dat   ;Used later to calculate HD Source vehicles 62

; 
  PRINT LIST='HPMSVtypeID        yearID         HPMSBaseYearVMT',file=@Pollutant@\VehicletypeVMT_daily.txt   
  print list='        10         ',{year4d}(4),'             ',_vmt10(12.2),file=@Pollutant@\VehicletypeVMT_daily.txt  
  print list='        25         ',{year4d}(4),'             ',_vmt25(12.2),file=@Pollutant@\VehicletypeVMT_daily.txt  
;  print list='        20         ',{year4d}(4),'             ',_vmt20(12.2),file=@Pollutant@\VehicletypeVMT.txt  
;  print list='        30         ',{year4d}(4),'             ',_vmt30(12.2),file=@Pollutant@\VehicletypeVMT.txt  
  print list='        40         ',{year4d}(4),'             ',_vmt40(12.2),file=@Pollutant@\VehicletypeVMT_daily.txt  
  print list='        50         ',{year4d}(4),'             ',_vmt50(12.2),file=@Pollutant@\VehicletypeVMT_daily.txt  
  print list='        60         ',{year4d}(4),'             ',_vmt60(12.2),file=@Pollutant@\VehicletypeVMT_daily.txt  

  PRINT csv=t,LIST='HPMSVtypeID  ','yearID  ','HPMSBaseYearVMT',file=@Pollutant@\VehicletypeVMT_daily.csv   
  print csv=t,list='10',{year4d}(4),_vmt10(12.2),file=@Pollutant@\VehicletypeVMT_daily.csv  
;  print csv=t,list='20',{year4d}(4),_vmt20(12.2),file=@Pollutant@\VehicletypeVMT.csv  
;  print csv=t,list='30',{year4d}(4),_vmt30(12.2),file=@Pollutant@\VehicletypeVMT.csv  
  print csv=t,list='25',{year4d}(4),_vmt25(12.2),file=@Pollutant@\VehicletypeVMT_daily.csv  
  print csv=t,list='40',{year4d}(4),_vmt40(12.2),file=@Pollutant@\VehicletypeVMT_daily.csv  
  print csv=t,list='50',{year4d}(4),_vmt50(12.2),file=@Pollutant@\VehicletypeVMT_daily.csv  
  print csv=t,list='60',{year4d}(4),_vmt60(12.2),file=@Pollutant@\VehicletypeVMT_daily.csv  

ENDRUN

*del @Pollutant@\HourVMTFractions.txt


LOOP RDTYPE=2,5
; LOOP HR=1,24

;===========================================================================================
; PRODUCE VMT FRACTIONS BY HOUR BY SOURCE BY ROAD TYPE BY HOUR
;===========================================================================================
RUN PGM=HWYNET
  NETI=@Pollutant@\MOVES_HrVOL.NET
  IF(ROADTYPE = @RDTYPE@)
   _VMT1 = _VMT1 + HR1
;       print list=a(8),b(8),roadtype(2),_vmt1(8.4),hr(4)
   _VMT2 = _VMT2 + HR2 
   _VMT3 = _VMT3 + HR3 
   _VMT4 = _VMT4 + HR4
   _VMT5 = _VMT5 + HR5 
   _VMT6 = _VMT6 + HR6 
   _VMT7 = _VMT7 + HR7 
   _VMT8 = _VMT8 + HR8 
   _VMT9 = _VMT9 + HR9
   _VMT10 = _VMT10 + HR10 
   _VMT11 = _VMT11 + HR11 
   _VMT12 = _VMT12 + HR12
   _VMT13 = _VMT13 + HR13 
   _VMT14 = _VMT14 + HR14 
   _VMT15 = _VMT15 + HR15 
   _VMT16 = _VMT16 + HR16 
   _VMT17 = _VMT17 + HR17 
   _VMT18 = _VMT18 + HR18 
   _VMT19 = _VMT19 + HR19 
   _VMT20 = _VMT20 + HR20 
   _VMT21 = _VMT21 + HR21 
   _VMT22 = _VMT22 + HR22 
   _VMT23 = _VMT23 + HR23 
   _VMT24 = _VMT24 + HR24 
;   print list=a(8),b(8),roadtype(2),_vmt1,hr1(8.4),_vmt6(9.4),hr6(9.4)
   _TOTVMT = _VMT1 + _VMT2 + _VMT3 + _VMT4 + _VMT5 + _VMT6 + _VMT7 + _VMT8 +
           _VMT9 + _VMT10 + _VMT11 + _VMT12 + _VMT13 + _VMT14 + _VMT15 + _VMT16 +
           _VMT17 + _VMT18 + _VMT19 + _VMT20 + _VMT21 + _VMT22 + _VMT23 + _VMT24

 ENDIF
PHASE=SUMMARY
;   _TOTVMT = _VMT1 + _VMT2 + _VMT3 + _VMT4 + _VMT5 + _VMT6 + _VMT7 + _VMT8 +
;           _VMT9 + _VMT10 + _VMT11 + _VMT12 + _VMT13 + _VMT14 + _VMT15 + _VMT16 +
;           _VMT17 + _VMT18 + _VMT19 + _VMT20 + _VMT21 + _VMT22 + _VMT23 + _VMT24
  IF(_TOTVMT>0)
;   print list=a(8),b(8),roadtype(2),_vmt1,_totvmt(8.2),file=list.tmp

 _HRB1 = ROUND(_VMT1 / _TOTVMT * 100000)/100000
 _HRB2 = ROUND(_VMT2 / _TOTVMT * 100000)/100000
 _HRB3 = ROUND(_VMT3 / _TOTVMT * 100000)/100000
 _HRB4 = ROUND(_VMT4 / _TOTVMT * 100000)/100000
 _HRB5 = ROUND(_VMT5 / _TOTVMT * 100000)/100000
 _HRB6 = ROUND(_VMT6 / _TOTVMT * 100000)/100000
 _HRB7 = ROUND(_VMT7 / _TOTVMT * 100000)/100000
 _HRB8 = ROUND(_VMT8 / _TOTVMT * 100000)/100000
 _HRB9 = ROUND(_VMT9 / _TOTVMT * 100000)/100000
 _HRB10 = ROUND(_VMT10 / _TOTVMT * 100000)/100000
 _HRB11 = ROUND(_VMT11 / _TOTVMT * 100000)/100000
 _HRB12 = ROUND(_VMT12 / _TOTVMT * 100000)/100000
 _HRB13 = ROUND(_VMT13 / _TOTVMT * 100000)/100000
 _HRB14 = ROUND(_VMT14 / _TOTVMT * 100000)/100000
 _HRB15 = ROUND(_VMT15 / _TOTVMT * 100000)/100000
 _HRB16 = ROUND(_VMT16 / _TOTVMT * 100000)/100000
 _HRB17 = ROUND(_VMT17 / _TOTVMT * 100000)/100000
 _HRB18 = ROUND(_VMT18 / _TOTVMT * 100000)/100000
 _HRB19 = ROUND(_VMT19 / _TOTVMT * 100000)/100000
 _HRB20 = ROUND(_VMT20 / _TOTVMT * 100000)/100000
 _HRB21 = ROUND(_VMT21 / _TOTVMT * 100000)/100000
 _HRB22 = ROUND(_VMT22 / _TOTVMT * 100000)/100000
 _HRB23 = ROUND(_VMT23 / _TOTVMT * 100000)/100000
 _HRB24 = ROUND(_VMT24 / _TOTVMT * 100000)/100000
ELSE
 _HRB1=0
 _HRB2=0
 _HRB3=0
 _HRB4=0
 _HRB5=0
 _HRB6=0
 _HRB7=0
 _HRB8=0
 _HRB9=0
 _HRB10=0
 _HRB11=0
 _HRB12=0
 _HRB13=0
 _HRB14=0
 _HRB15=0
 _HRB16=0
 _HRB17=0
 _HRB18=0
 _HRB19=0
 _HRB20=0
 _HRB21=0
 _HRB22=0
 _HRB23=0
 _HRB24=0
ENDIF
 ; Ensure rounded speed bin fractions sum to one
 _sum=_HRB1+_HRB2+_HRB3+_HRB4+_HRB5+_HRB6+_HRB7+_HRB8+_HRB9+_HRB10+_HRB11+_HRB12+_HRB13+_HRB14+_HRB15+_HRB16+
       _HRB17+_HRB18+_HRB19+_HRB20+_HRB21+_HRB22+_HRB23+_HRB24
 _diff=1-_sum
 ; start from the highest bin and work backwords to find a bin
 ; that can be adjusted without becoming less than zero
 if (_HRB24>abs(_diff))
   _HRB24=_HRB24+_diff
 elseif (_HRB23>abs(_diff))
   _HRB23=_HRB23+_diff
 elseif (_HRB22>abs(_diff))
   _HRB22=_HRB22+_diff
 elseif (_HRB21>abs(_diff))
   _HRB21=_HRB21+_diff
 elseif (_HRB20>abs(_diff))
   _HRB20=_HRB20+_diff
 elseif (_HRB19>abs(_diff))
   _HRB19=_HRB19+_diff
 elseif (_HRB18>abs(_diff))
   _HRB18=_HRB18+_diff
 elseif (_HRB17>abs(_diff))
   _HRB17=_HRB1+_diff
 elseif (_HRB16>abs(_diff))
   _HRB16=_HRB16+_diff
 elseif (_HRB15>abs(_diff))
   _HRB15=_HRB15+_diff
 elseif (_HRB14>abs(_diff))
   _HRB14=_HRB14+_diff
 elseif (_HRB13>abs(_diff))
   _HRB13=_HRB13+_diff
 elseif (_HRB12>abs(_diff))
   _HRB12=_HRB12+_diff
 elseif (_HRB11>abs(_diff))
   _HRB11=_HRB11+_diff
 elseif (_HRB10>abs(_diff))
   _HRB10=_HRB10+_diff
 elseif (_HRB9>abs(_diff))
   _HRB9=_HRB9+_diff
 elseif (_HRB8>abs(_diff))
   _HRB8=_HRB8+_diff
 elseif (_HRB7>abs(_diff))
   _HRB7=_HRB7+_diff
 elseif (_HRB6>abs(_diff))
   _HRB6=_HRB6+_diff
 elseif (_HRB5>abs(_diff))
   _HRB5=_HRB5+_diff
 elseif (_HRB4>abs(_diff))
   _HRB4=_HRB4+_diff
 elseif (_HRB3>abs(_diff))
   _HRB3=_HRB3+_diff
 elseif (_HRB2>abs(_diff))
   _HRB2=_HRB2+_diff
 else
   _HRB1=_HRB1+_diff
 endif

LOOP _SOURCE=1,13
 IF (_SOURCE=1)
  SOURCEID = 11
 ELSEIF (_SOURCE=2)
  SOURCEID = 21
 ELSEIF (_SOURCE=3)
  SOURCEID = 31
 ELSEIF (_SOURCE=4)
  SOURCEID = 32
 ELSEIF (_SOURCE=5)
  SOURCEID = 41
 ELSEIF (_SOURCE=6)
  SOURCEID = 42
 ELSEIF (_SOURCE=7)
  SOURCEID = 43
 ELSEIF (_SOURCE=8)
  SOURCEID = 51
 ELSEIF (_SOURCE=9)
  SOURCEID = 52
 ELSEIF (_SOURCE=10)
  SOURCEID = 53
 ELSEIF (_SOURCE=11)
  SOURCEID = 54
 ELSEIF (_SOURCE=12)
  SOURCEID = 61
 ELSEIF (_SOURCE=13)
  SOURCEID = 62
 ENDIF

 PRINT FORM=5.0,LIST=SOURCEID,@RDTYPE@,'  5','    1',_HRB1(10.5),FILE=@Pollutant@\HourVMTFractions.txt,append=t
 PRINT FORM=5.0,LIST=SOURCEID,@RDTYPE@,'  5','    2',_HRB2(10.5),FILE=@Pollutant@\HourVMTFractions.txt,append=t
 PRINT FORM=5.0,LIST=SOURCEID,@RDTYPE@,'  5','    3',_HRB3(10.5),FILE=@Pollutant@\HourVMTFractions.txt,append=t
 PRINT FORM=5.0,LIST=SOURCEID,@RDTYPE@,'  5','    4',_HRB4(10.5),FILE=@Pollutant@\HourVMTFractions.txt,append=t
 PRINT FORM=5.0,LIST=SOURCEID,@RDTYPE@,'  5','    5',_HRB5(10.5),FILE=@Pollutant@\HourVMTFractions.txt,append=t
 PRINT FORM=5.0,LIST=SOURCEID,@RDTYPE@,'  5','    6',_HRB6(10.5),FILE=@Pollutant@\HourVMTFractions.txt,append=t
 PRINT FORM=5.0,LIST=SOURCEID,@RDTYPE@,'  5','    7',_HRB7(10.5),FILE=@Pollutant@\HourVMTFractions.txt,append=t
 PRINT FORM=5.0,LIST=SOURCEID,@RDTYPE@,'  5','    8',_HRB8(10.5),FILE=@Pollutant@\HourVMTFractions.txt,append=t
 PRINT FORM=5.0,LIST=SOURCEID,@RDTYPE@,'  5','    9',_HRB9(10.5),FILE=@Pollutant@\HourVMTFractions.txt,append=t
 PRINT FORM=5.0,LIST=SOURCEID,@RDTYPE@,'  5','   10',_HRB10(10.5),FILE=@Pollutant@\HourVMTFractions.txt,append=t
 PRINT FORM=5.0,LIST=SOURCEID,@RDTYPE@,'  5','   11',_HRB11(10.5),FILE=@Pollutant@\HourVMTFractions.txt,append=t
 PRINT FORM=5.0,LIST=SOURCEID,@RDTYPE@,'  5','   12',_HRB12(10.5),FILE=@Pollutant@\HourVMTFractions.txt,append=t
 PRINT FORM=5.0,LIST=SOURCEID,@RDTYPE@,'  5','   13',_HRB13(10.5),FILE=@Pollutant@\HourVMTFractions.txt,append=t
 PRINT FORM=5.0,LIST=SOURCEID,@RDTYPE@,'  5','   14',_HRB14(10.5),FILE=@Pollutant@\HourVMTFractions.txt,append=t
 PRINT FORM=5.0,LIST=SOURCEID,@RDTYPE@,'  5','   15',_HRB15(10.5),FILE=@Pollutant@\HourVMTFractions.txt,append=t
 PRINT FORM=5.0,LIST=SOURCEID,@RDTYPE@,'  5','   16',_HRB16(10.5),FILE=@Pollutant@\HourVMTFractions.txt,append=t
 PRINT FORM=5.0,LIST=SOURCEID,@RDTYPE@,'  5','   17',_HRB17(10.5),FILE=@Pollutant@\HourVMTFractions.txt,append=t
 PRINT FORM=5.0,LIST=SOURCEID,@RDTYPE@,'  5','   18',_HRB18(10.5),FILE=@Pollutant@\HourVMTFractions.txt,append=t
 PRINT FORM=5.0,LIST=SOURCEID,@RDTYPE@,'  5','   19',_HRB19(10.5),FILE=@Pollutant@\HourVMTFractions.txt,append=t
 PRINT FORM=5.0,LIST=SOURCEID,@RDTYPE@,'  5','   20',_HRB20(10.5),FILE=@Pollutant@\HourVMTFractions.txt,append=t
 PRINT FORM=5.0,LIST=SOURCEID,@RDTYPE@,'  5','   21',_HRB21(10.5),FILE=@Pollutant@\HourVMTFractions.txt,append=t
 PRINT FORM=5.0,LIST=SOURCEID,@RDTYPE@,'  5','   22',_HRB22(10.5),FILE=@Pollutant@\HourVMTFractions.txt,append=t
 PRINT FORM=5.0,LIST=SOURCEID,@RDTYPE@,'  5','   23',_HRB23(10.5),FILE=@Pollutant@\HourVMTFractions.txt,append=t
 PRINT FORM=5.0,LIST=SOURCEID,@RDTYPE@,'  5','   24',_HRB24(10.5),FILE=@Pollutant@\HourVMTFractions.txt,append=t
  ENDLOOP   ;SOURCEID
ENDPHASE
ENDRUN


; ENDLOOP   ;HR
ENDLOOP    ;RDTYPE


;ADD IN OFF-ROAD DEFAULTS
RUN PGM=MATRIX
RECI=@HourFracRT1@,DELIMITER="," SOURCETYPEID=1,ROADTYPEID=2,DAYID=3,HOURID=4,HOURVMTFRACTION=5
_CNT=_CNT+1
IF(_CNT>1)
 PRINT FORM=5.0,LIST=RI.SOURCETYPEID,RI.ROADTYPEID,RI.DAYID(3.0),RI.HOURID,RI.HOURVMTFRACTION(10.5),FILE=@Pollutant@\HourVMTFractions.txt,append=t
ENDIF
ENDRUN

;REMOVE EMPTY LINES OF DATA FROM APPENDING TEXT FILE
RUN PGM=MATRIX
DBI[1]=@Pollutant@\HourVMTFractions.txt,source=1,rdtype=2,day=3,hourday=4,vmtfrac=5
RECO[1]=@Pollutant@\HourVMTFRACTIONS.TMP,FIELDS=source,rdType,day,hourDay,vmtFrac(10.5)

ZONES=1

 LOOP K=1,DBI.1.NUMRECORDS
  X=DBIREADRECORD(1,K)
 IF(DI.1.SOURCE>0)
  RO.source = DI.1.SOURCE
  RO.rdType = DI.1.RDTYPE
  RO.day = DI.1.DAY
  RO.hourDay = DI.1.HOURDAY
  RO.VMTFrac = DI.1.VMTFRAC
  WRITE RECO=1
 ENDIF
 ENDLOOP
ENDRUN

;SORT SPEED FRACTIONS FOR INPUT TO MOVES
;Normalize Speed Fractions by each SourceType, RoadType and hourDay combination
RUN PGM=MATRIX
DBI[1]=@Pollutant@\HourVMTFractions.tmp,SORT=source,rdType,hourDay
RECO[1]=@Pollutant@\HourVMTFractions.dbf,FIELDS=sourceID(10.0),rdTypeID(10.0),dayID(10.0),hourID(10.0),HourVMTFraction(15.5)

ZONES=1

 LOOP K=1,DBI.1.NUMRECORDS
  X=DBIREADRECORD(1,K)
  RO.sourceID = DI.1.source
  RO.rdTypeID = DI.1.rdType
  RO.dayID = DI.1.Day
  RO.hourID = DI.1.hourDay
  RO.HourVMTFraction = DI.1.VMTFrac
  WRITE RECO=1
 ENDLOOP
ENDRUN
RUN PGM=MATRIX
RECI=@Pollutant@\HourVMTFractions.dbf
PRINTO[1]=@Pollutant@\HourVMTFractions.csv

  sourceID=RI.sourceID
  rdTypeID = RI.rdTypeID
  dayID = RI.DayID
  hourID = RI.hourID
  HourVMTFrac = RI.HourVMTFrac
  if(reci.recno=1) print list='sourceTypeid,roadTypeID,dayID,hourID,HourVMTFraction',printo=1
  Print csv=t,list=sourceid(4),rdTypeID(4),dayID(4),hourID(4),HourVMTFrac(9.5),printo=1

ENDRUN
*copy @Pollutant@\HourVMTFractions.csv @Pollutant@\MOVESInputs\HourVMTFractions_@Pollutant@.csv

;================================================================================================================
;Following steps to replace use of AADVMT spreadsheet
; USER MUST CREATE MonthlyWeekendAdjFactors.CSV (formatted cells to 15 decimal places to replicate calculations


;create vehicle type vmt dbf for lookup in subsequent step
RUN PGM=MATRIX
RECI=@Pollutant@\VehicleTypeVMT_daily.csv,DELIMITER=',' HPMS=1,yearID=2,VMT=3
RECO=@Pollutant@\VehicleTypeVMT_daily.DBF,FIELDS=HPMS,yearID,VMT(15.5)
IF(RECI.RECNO>1)
 YEAR = RI.yearID
 RO.yearID=RI.yearID
 RO.HPMS=RI.HPMS
 RO.VMT=RI.VMT
 WRITE RECO=1
 LOG VAR=YEAR
ENDIF
ENDRUN
;Read in user created monthly/weekend adjustment factors and add days for month (including leap years for February)
;Creates dbf with days used in subsequent step
RUN PGM=MATRIX
RECI=@monthlyweekend@,DELIMITER=',' HPMS=1,monthID=2,Month(c)=3,MnFac=4,WkFac=5
RECO=@Pollutant@\MonthlyWeekendAdjFactors.DBF,FIELDS=HPMS,monthID,Month,MnFac(20.15),WkFac(20.15),DAYS
IF(RECI.RECNO>1)
 RO.HPMS=RI.HPMS
 RO.monthID=RI.monthID
 RO.Month=RI.Month
 RO.MnFac=RI.MnFac
 RO.WkFac=RI.WkFac
 IF(RI.monthID=1) RO.DAYS=31
 IF(RI.monthID=2) RO.DAYS=28
 IF(RI.monthID=3) RO.DAYS=31
 IF(RI.monthID=4) RO.DAYS=30
 IF(RI.monthID=5) RO.DAYS=31
 IF(RI.monthID=6) RO.DAYS=30
 IF(RI.monthID=7) RO.DAYS=31
 IF(RI.monthID=8) RO.DAYS=31
 IF(RI.monthID=9) RO.DAYS=30
 IF(RI.monthID=10) RO.DAYS=31
 IF(RI.monthID=11) RO.DAYS=30
 IF(RI.monthID=12) RO.DAYS=31
 
 WRITE RECO=1
ENDIF
ENDRUN
;Replicate VMT calculations from AADVMT spreadsheet
; output VMTCalcs.dbf for checking AADVMT spreadsheet and summary in subsequent step
;  WkDyVMT = column J in Daily VMT by HPMS and Month worksheet
;  WkndVMT = column K in Daily VMT by HPMS and Month worksheet
;  MoWkyVMT = column E in Month VMT worksheet
;  MoWkdVMT = column F in Month VMT worksheet
;  MoVMT = column G in Month VMT worksheet

RUN PGM=MATRIX
RECI=@Pollutant@\MonthlyWeekendAdjFactors.DBF
RECO[1]=@Pollutant@\VMTCalcs.DBF,FIELDS=HPMS,MnFac(20.15),WkFac(20.15),WkdyVMT(20.5),WkndVMT(20.5),Days,MoWkyVMT(20.5),MoWkdVMT(20.5),MoVMT(20.5)
RO.HPMS=RI.HPMS
RO.MonthID=RI.MonthID
RO.MnFac=RI.MnFac
RO.WkFac=RI.WkFac
RO.DAYS=RI.DAYS
   Lookup Name=_VMT,
    Lookup[1]=HPMS,Result=VMT,File=@Pollutant@\VehicleTypeVMT_daily.DBF,
     Interpolate=n

     RO.WkdyVMT=_VMT(1,RI.HPMS)*RI.MnFac
     RO.WkndVMT=RO.WkdyVMT*RI.WkFac
     RO.MoWkyVMT=RO.WkdyVMT*RI.DAYS*5/7
     RO.MoWkdVMT=RO.WkndVMT*RI.DAYS*2/7
     RO.MoVMT=RO.MoWkyVMT+RO.MoWkdVMT
 WRITE RECO=1

  _totvmt = _totvmt + RO.MoVMT
 
LOG VAR = _totvmt
ENDRUN
;summarize vmt calculations
; log type 60 vmt for input into subsequent step
; print out CSV for MOVES (HPMS_VMT.CSV)
RUN PGM=MATRIX
RECI=@Pollutant@\VMTCalcs.DBF
PRINTO[1]=@Pollutant@\VehicleTypeVMT.CSV

yearID=@matrix.year@
IF(RI.HPMS=10) _vmt10=_vmt10+RI.MOVMT
IF(RI.HPMS=25) _vmt25=_vmt25+RI.MOVMT
;IF(RI.HPMS=20) _vmt20=_vmt20+RI.MOVMT
;IF(RI.HPMS=30) _vmt30=_vmt30+RI.MOVMT
IF(RI.HPMS=40) _vmt40=_vmt40+RI.MOVMT
IF(RI.HPMS=50) _vmt50=_vmt50+RI.MOVMT
IF(RI.HPMS=60) _vmt60=_vmt60+RI.MOVMT

_pctvmt10 = _vmt10 / @matrix._totvmt@
_pctvmt25 = _vmt25 / @matrix._totvmt@
;_pctvmt20 = _vmt20 / @matrix._totvmt@
;_pctvmt30 = _vmt30 / @matrix._totvmt@
_pctvmt40 = _vmt40 / @matrix._totvmt@
_pctvmt50 = _vmt50 / @matrix._totvmt@
_pctvmt60 = _vmt60 / @matrix._totvmt@

IF(RECI.RECNO=1) PRINT LIST='HPMSVTypeID,yearID,HPMSBaseYearVMT,baseYearOffNetVMT',printo=1
IF(RECI.RECNO=12) PRINT CSV=T,LIST=RI.HPMS(8.0),yearID(8.0),_vmt10(20.5),'0',printo=1
IF(RECI.RECNO=24) PRINT CSV=T,LIST=RI.HPMS(8.0),yearID(8.0),_vmt25(20.5),'0',printo=1
;IF(RECI.RECNO=24) PRINT CSV=T,LIST=RI.HPMS(8.0),yearID(8.0),_vmt20(20.5),'0',_pctVMT20(8.6),printo=1
;IF(RECI.RECNO=36) PRINT CSV=T,LIST=RI.HPMS(8.0),yearID(8.0),_vmt30(20.5),'0',_pctVMT30(8.6),printo=1
IF(RECI.RECNO=36) PRINT CSV=T,LIST=RI.HPMS(8.0),yearID(8.0),_vmt40(20.5),'0',printo=1
IF(RECI.RECNO=48) PRINT CSV=T,LIST=RI.HPMS(8.0),yearID(8.0),_vmt50(20.5),'0',printo=1
IF(RECI.RECNO=60) PRINT CSV=T,LIST=RI.HPMS(8.0),yearID(8.0),_vmt60(20.5),'0',printo=1

LOG VAR = _VMT60  ;log for later use

ENDRUN

*copy @Pollutant@\VehicletypeVMT.csv @Pollutant@\MOVESInputs\VehicletypeVMT_@Pollutant@.csv

RUN PGM=NETWORK
;  This script produces the RoadTypeVMTDistribution.dbf - Updated for the new 5,000+ ARC Model Structure
;   Uses MOVES Default VMT by Source Vehicle to allocated the VMT by Road Type
;      Also calculates the revised heavey duty vehicles 62 
;               Added factors for 2030 and 2040    090911

  NETI=@Pollutant@\MOVES_HRVOL.Net   ;  LOADED HIGHWAY NETWORK 24-HR (SUM OF PERIODS)
  _vmttmp=toteavmtadj+totamvmtadj+totmdvmtadj+totpmvmtadj+totevvmtadj
;
 _VMT1 = 0
IF(ROADTYPE = 2)
      _VMT2 = _VMT2 + _vmttmp
   ELSEIF(ROADTYPE = 3)
      _VMT3 = _VMT3 + _vmttmp 
   ELSEIF(ROADTYPE = 4)
      _VMT4 = _VMT4 + _vmttmp
    ELSEIF(ROADTYPE = 5)
      _VMT5 = _VMT5 + _vmttmp
ENDIF

PHASE=SUMMARY
PRINT LIST='1 ',_VMT1(12.0),FILE=@Pollutant@\RDTYPEVMT.TXT
PRINT LIST='2 ',_VMT2(12.0),FILE=@Pollutant@\RDTYPEVMT.TXT
PRINT LIST='3 ',_VMT3(12.0),FILE=@Pollutant@\RDTYPEVMT.TXT
PRINT LIST='4 ',_VMT4(12.0),FILE=@Pollutant@\RDTYPEVMT.TXT
PRINT LIST='5 ',_VMT5(12.0),FILE=@Pollutant@\RDTYPEVMT.TXT
ENDPHASE
ENDRUN
RUN PGM=MATRIX
RECO[1]=@Pollutant@\Sourcetype_Year.dbf,FIELDS=NUMBER,SOURCETYPE,FRACTION(8.5)
ZONES=1

   ;Get MOVES default Source Vehicle fractions by year
        _year=int({year4d})

   Lookup Name=_moves11,             
    Lookup[1]=1,Result=2,File=@source13@,
     Interpolate=n
     _Frac11=_moves11(1,_year)
   Lookup Name=_moves21,             
    Lookup[1]=1,Result=3,File=@source13@,
     Interpolate=n
     _Frac21=_moves21(1,_year)
   Lookup Name=_moves31,             
    Lookup[1]=1,Result=4,File=@source13@,
     Interpolate=n
     _Frac31=_moves31(1,_year)
   Lookup Name=_moves32,             
    Lookup[1]=1,Result=5,File=@source13@,
     Interpolate=n
     _Frac32=_moves32(1,_year)
   Lookup Name=_moves41,             
    Lookup[1]=1,Result=6,File=@source13@,
     Interpolate=n
     _Frac41=_moves41(1,_year)
   Lookup Name=_moves42,             
    Lookup[1]=1,Result=7,File=@source13@,
     Interpolate=n
     _Frac42=_moves42(1,_year)
   Lookup Name=_moves43,             
    Lookup[1]=1,Result=8,File=@source13@,
     Interpolate=n
     _Frac43=_moves43(1,_year)
   Lookup Name=_moves51,             
    Lookup[1]=1,Result=9,File=@source13@,
     Interpolate=n
     _Frac51=_moves51(1,_year)
   Lookup Name=_moves52,             
    Lookup[1]=1,Result=10,File=@source13@,
     Interpolate=n
     _Frac52=_moves52(1,_year)
   Lookup Name=_moves53,             
    Lookup[1]=1,Result=11,File=@source13@,
     Interpolate=n
     _Frac53=_moves53(1,_year)
   Lookup Name=_moves54,             
    Lookup[1]=1,Result=12,File=@source13@,
     Interpolate=n
     _Frac54=_moves54(1,_year)
   Lookup Name=_moves61,             
    Lookup[1]=1,Result=13,File=@source13@,
     Interpolate=n
     _Frac61=_moves61(1,_year)
   Lookup Name=_moves62,             
    Lookup[1]=1,Result=14,File=@source13@,
     Interpolate=n
     _Frac62=_moves62(1,_year)
 
    RO.NUMBER=1
    RO.SOURCETYPE=11
    RO.FRACTION=_FRAC11
    WRITE RECO=1
    RO.NUMBER=2
    RO.SOURCETYPE=21
    RO.FRACTION=_FRAC21
    WRITE RECO=1
    RO.NUMBER=3
    RO.SOURCETYPE=31
    RO.FRACTION=_FRAC31
    WRITE RECO=1
    RO.NUMBER=4
    RO.SOURCETYPE=32
    RO.FRACTION=_FRAC32
    WRITE RECO=1
    RO.NUMBER=5
    RO.SOURCETYPE=41
    RO.FRACTION=_FRAC41
    WRITE RECO=1
    RO.NUMBER=6
    RO.SOURCETYPE=42
    RO.FRACTION=_FRAC42
    WRITE RECO=1
    RO.NUMBER=7
    RO.SOURCETYPE=43
    RO.FRACTION=_FRAC43
    WRITE RECO=1
    RO.NUMBER=8
    RO.SOURCETYPE=51
    RO.FRACTION=_FRAC51
    WRITE RECO=1
    RO.NUMBER=9
    RO.SOURCETYPE=52
    RO.FRACTION=_FRAC52
    WRITE RECO=1
    RO.NUMBER=10
    RO.SOURCETYPE=53
    RO.FRACTION=_FRAC53
    WRITE RECO=1
    RO.NUMBER=11
    RO.SOURCETYPE=54
    RO.FRACTION=_FRAC54
    WRITE RECO=1
    RO.NUMBER=12
    RO.SOURCETYPE=61
    RO.FRACTION=_FRAC61
    WRITE RECO=1
    RO.NUMBER=13
    RO.SOURCETYPE=62
    RO.FRACTION=_FRAC62
    WRITE RECO=1

   log var=_frac61                     ;Use these fractions later to calculate number of HD vehicles 62
   log var=_frac62

RUN PGM=MATRIX
DBI[1]=@Pollutant@\RDTYPEVMT.TXT,RDTYPE=1,VMT=2
DBI[2]=@Pollutant@\SourceType_YEAR.dbf
RECO[1]=@Pollutant@\RoadTypeVMT.dbf,FIELDS=SOURCE,RDTYPE,VMT
ZONES=1

LOOP A=1,DBI.2.NUMRECORDS
 X=DBIREADRECORD(2,A)
  RO.SOURCE=DI.2.SOURCETYPE
  VMT = 0
  _VMT = 0
  LOOP B=1,DBI.1.NUMRECORDS
   Y=DBIREADRECORD(1,B)
    RO.RDTYPE = DI.1.RDTYPE
    RO.VMT=DI.2.FRACTION * DI.1.VMT
    WRITE RECO=1
  ENDLOOP
ENDLOOP
ENDRUN
RUN PGM=MATRIX
DBI[1]=@Pollutant@\RoadTypeVMT.DBF
RECO[1]=@Pollutant@\RoadTypeVMTDistribution.DBF,FIELDS=SOURCEID(4),RDTYPEID(4),ROADTYPEVMTFRACTION(8.6)
ZONES=1

 LOOP A = 1,DBI.1.NUMRECORDS
  X=DBIREADRECORD(1,A)
   IF(DI.1.SOURCE = 11) _VMT11 = _VMT11 + DI.1.VMT
   IF(DI.1.SOURCE = 21) _VMT21 = _VMT21 + DI.1.VMT
   IF(DI.1.SOURCE = 31) _VMT31 = _VMT31 + DI.1.VMT
   IF(DI.1.SOURCE = 32) _VMT32 = _VMT32 + DI.1.VMT
   IF(DI.1.SOURCE = 41) _VMT41 = _VMT41 + DI.1.VMT
   IF(DI.1.SOURCE = 42) _VMT42 = _VMT42 + DI.1.VMT
   IF(DI.1.SOURCE = 43) _VMT43 = _VMT43 + DI.1.VMT
   IF(DI.1.SOURCE = 51) _VMT51 = _VMT51 + DI.1.VMT
   IF(DI.1.SOURCE = 52) _VMT52 = _VMT52 + DI.1.VMT
   IF(DI.1.SOURCE = 53) _VMT53 = _VMT53 + DI.1.VMT
   IF(DI.1.SOURCE = 54) _VMT54 = _VMT54 + DI.1.VMT
   IF(DI.1.SOURCE = 61) _VMT61 = _VMT61 + DI.1.VMT
   IF(DI.1.SOURCE = 62) _VMT62 = _VMT62 + DI.1.VMT
 ENDLOOP

 LOOP B = 1,DBI.1.NUMRECORDS
  X=DBIREADRECORD(1,B)
   RO.SOURCEID = DI.1.SOURCE
   RO.RDTYPEID = DI.1.RDTYPE
   IF(DI.1.SOURCE = 11) RO.ROADTYPEVMTFRACTION = DI.1.VMT / _VMT11
   IF(DI.1.SOURCE = 21) RO.ROADTYPEVMTFRACTION = DI.1.VMT / _VMT21
   IF(DI.1.SOURCE = 31) RO.ROADTYPEVMTFRACTION = DI.1.VMT / _VMT31
   IF(DI.1.SOURCE = 32) RO.ROADTYPEVMTFRACTION = DI.1.VMT / _VMT32
   IF(DI.1.SOURCE = 41) RO.ROADTYPEVMTFRACTION = DI.1.VMT / _VMT41
   IF(DI.1.SOURCE = 42) RO.ROADTYPEVMTFRACTION = DI.1.VMT / _VMT42
   IF(DI.1.SOURCE = 43) RO.ROADTYPEVMTFRACTION = DI.1.VMT / _VMT43
   IF(DI.1.SOURCE = 51) RO.ROADTYPEVMTFRACTION = DI.1.VMT / _VMT51
   IF(DI.1.SOURCE = 52) RO.ROADTYPEVMTFRACTION = DI.1.VMT / _VMT52
   IF(DI.1.SOURCE = 53) RO.ROADTYPEVMTFRACTION = DI.1.VMT / _VMT53
   IF(DI.1.SOURCE = 54) RO.ROADTYPEVMTFRACTION = DI.1.VMT / _VMT54
   IF(DI.1.SOURCE = 61) RO.ROADTYPEVMTFRACTION = DI.1.VMT / _VMT61
   IF(DI.1.SOURCE = 62) RO.ROADTYPEVMTFRACTION = DI.1.VMT / _VMT62
   WRITE RECO=1
 ENDLOOP
ENDRUN
RUN PGM=MATRIX
RECI=@Pollutant@\RoadTypeVMTDistribution.dbf
PRINTO[1]=@Pollutant@\RoadTypeVMTDistribution.csv

  sourceID = RI.sourceID
  rdTypeID = RI.rdTypeID
  RoadTypeVMTFraction = RI.RoadTypeVMT
  if(reci.recno=1) print list='sourceTypeid,roadTypeID,RoadTypeVMTFraction',printo=1
  Print csv=t,list=sourceid(4),rdTypeID(4),RoadTypeVMTFraction(10.6),printo=1

ENDRUN

RUN PGM=MATRIX
;Calculate Heavy Duty Source vehicles 62 to be used in Source population file
;ZDATI[1]=VMT60.DAT,Z=#1,VMT60=2
  
ZONES=1
        _year=int({year4d})

  TOTFRAC60=@MATRIX._FRAC61@+@MATRIX._FRAC62@
  TOTFRAC62=@MATRIX._FRAC62@/TOTFRAC60
;   MOVES Defaults VMT/Pop = 61758
   Lookup Name=_ratio,             
    Lookup[1]=1,Result=2,File=@hdsource@,
     Interpolate=n
     ratio=_ratio(1,_year)
 
       TOTVEH62=(@matrix._vmt60@*TOTFRAC62)/ratio

print list='Source vehicles 62 =',totveh62,file=@Pollutant@\Src_Vehicle62.dat
ENDRUN
*copy @Pollutant@\RoadTypeVMTDistribution.csv @Pollutant@\MOVESInputs\RoadTypeVMTDistribution_@Pollutant@.csv
*copy @Pollutant@\Src_Vehicle62.dat @Pollutant@\MOVESInputs\Src_Vehicle62_@Pollutant@.dat

ENDLOOP

;compute the total number of trips with origins inside the ARC region
RUN PGM=MATRIX
MATI[1]=..\ModelData\TODEA{year}_asgn.VTT
MATI[2]=..\ModelData\TODAM{year}_asgn.VTT
MATI[3]=..\ModelData\TODMD{year}_asgn.VTT
MATI[4]=..\ModelData\TODPM{year}_asgn.VTT
MATI[5]=..\ModelData\TODEV{year}_asgn.VTT
MATI[6]=..\ModelData\COM.TRP
MATI[7]=..\ModelData\MTK.TRP
MATI[8]=..\ModelData\HTK.TRP
PRINTO[1]=13Co_O3\MOVESInputs\startsPerDay_13Co_O3.CSV
PRINTO[2]=13Co_PM\MOVESInputs\startsPerDay_13Co_PM.CSV
PRINTO[3]=7Co_O3\MOVESInputs\startsPerDay_7Co_O3.CSV
PRINTO[4]=7Co_PM\MOVESInputs\startsPerDay_7Co_PM.CSV
PRINTO[5]=5Co_O3\MOVESInputs\startsPerDay_5Co_O3.CSV
PRINTO[6]=5Co_PM\MOVESInputs\startsPerDay_5Co_PM.CSV
PRINTO[7]=2Co_O3\MOVESInputs\startsPerDay_2Co_O3.CSV
PRINTO[8]=2Co_PM\MOVESInputs\startsPerDay_2Co_PM.CSV
ZONEMSG=25

;fill working tables
FILLMW MW[101]=MI.1.1(6)  ;EA passenger car
FILLMW MW[201]=MI.2.1(6)  ;AM passenger car
FILLMW MW[301]=MI.3.1(6)  ;MD passenger car
FILLMW MW[401]=MI.4.1(6)  ;PM passenger car
FILLMW MW[501]=MI.5.1(6)  ;PM passenger car
FILLMW MW[601]=MI.6.1(5)  ;com by period
FILLMW MW[701]=MI.7.1(5)  ;mtk by period
FILLMW MW[801]=MI.8.1(5)  ;htk by period

;compute total by time period
EA = ROWADD(11,101,102,103,104,105,106)
AM = ROWADD(21,201,202,203,204,205,206)
MD = ROWADD(31,301,302,303,304,305,306)
PM = ROWADD(41,401,402,403,404,405,406)
EV = ROWADD(51,501,502,503,504,505,506)

;compute daily total by vehicle class 
CAR = ROWADD(1,11,21,31,41,51)
COM = ROWADD(2,601,602,603,604,605)
MTK = ROWADD(3,701,702,703,704,705)
HTK = ROWADD(4,801,802,803,804,805)
TOT = ROWADD(5,1,2,3,4)

zone13 = 131210
zone7 = 130150
zone5 = 131210
zone2 = 130150
day = 5
year = {year4d}

;check for an origin in the ARC region(only process rows <= internal zone number)
JLOOP
 IF(I={county13})
  _CAR13 = _CAR13 + MW[1]
  _COM13 = _COM13 + MW[2]
  _MTK13 = _MTK13 + MW[3]
  _HTK13 = _HTK13 + MW[4]
  _TOT13 = _TOT13 + MW[5]
 ELSEIF(I={county7})
  _CAR7 = _CAR7 + MW[1]
  _COM7 = _COM7 + MW[2]
  _MTK7 = _MTK7 + MW[3]
  _HTK7 = _HTK7 + MW[4]
  _TOT7 = _TOT7 + MW[5]
 ENDIF
 IF(I={county5})
  _CAR5 = _CAR5 + MW[1]
  _COM5 = _COM5 + MW[2]
  _MTK5 = _MTK5 + MW[3]
  _HTK5 = _HTK5 + MW[4]
  _TOT5 = _TOT5 + MW[5]
 ENDIF
 IF(I={county2})
  _CAR2 = _CAR2 + MW[1]
  _COM2 = _COM2 + MW[2]
  _MTK2 = _MTK2 + MW[3]
  _HTK2 = _HTK2 + MW[4]
  _TOT2 = _TOT2 + MW[5]
 ENDIF
ENDJLOOP
IF(I={ext2})
 PRINT FORM=12.0, LIST='CAR starts ',_CAR13,_CAR7,_CAR5,_CAR2,FILE=Starts.prn
 PRINT FORM=12.0, LIST='COM starts ',_COM13,_COM7,_COM5,_COM2,FILE=Starts.prn
 PRINT FORM=12.0, LIST='MTK starts ',_MTK13,_MTK7,_MTK5,_MTK2,FILE=Starts.prn
 PRINT FORM=12.0, LIST='HTK starts ',_HTK13,_HTK7,_HTK5,_HTK2,FILE=Starts.prn
 PRINT FORM=12.0, LIST='TOT starts ',_TOT13,_TOT7,_TOT5,_TOT2,FILE=Starts.prn
ENDIF
;PRINT TO CSV
  if(I=1)
   print list='zoneID,dayID,yearID,startsPerDay',printo=1
   print list='zoneID,dayID,yearID,startsPerDay',printo=2
   print list='zoneID,dayID,yearID,startsPerDay',printo=3
   print list='zoneID,dayID,yearID,startsPerDay',printo=4
   print list='zoneID,dayID,yearID,startsPerDay',printo=5
   print list='zoneID,dayID,yearID,startsPerDay',printo=6
   print list='zoneID,dayID,yearID,startsPerDay',printo=7
   print list='zoneID,dayID,yearID,startsPerDay',printo=8
  endif
  if(I={ext2})
   Print csv=t,list=zone13,day,year,_tot13(12.0),printo=1
   Print csv=t,list=zone13,day,year,_tot13(12.0),printo=2
   Print csv=t,list=zone7,day,year,_tot7(12.0),printo=3
   Print csv=t,list=zone7,day,year,_tot7(12.0),printo=4
   Print csv=t,list=zone5,day,year,_tot5(12.0),printo=5
   Print csv=t,list=zone5,day,year,_tot5(12.0),printo=6
   Print csv=t,list=zone2,day,year,_tot2(12.0),printo=7
   Print csv=t,list=zone2,day,year,_tot2(12.0),printo=8
  endif
ENDRUN